import {PlateElement, withRef} from '@udecode/plate-common/react';
import * as React from 'react';

export const TableRowElement = withRef<
    typeof PlateElement,
    {
        hideBorder?: boolean;
    }
>(({children, hideBorder, style, ...props}, ref) => {
    const ghost = React.useMemo(() => <span className='ghost' contentEditable={false}/>, []);
    return (
        <PlateElement
            asChild
            style={{
                ...style,
                borderStyle: hideBorder ? 'none' : undefined,
                height: '100%', /* h-full */
                position: 'relative',
            }}
            // @ts-expect-error ignore
            ref={ref}
            {...props}
        >
            <tr>
                {ghost}
                {children}
            </tr>
        </PlateElement>
    );
});
