import {PlateElement, withRef} from '@udecode/plate-common/react';
import * as React from 'react';

export const RootElement = withRef<typeof PlateElement>(
    ({children, style, ...props}, ref) => {
        const ghost = React.useMemo(() => <span className='ghost' contentEditable={false}/>, []);
        return (
            // @ts-expect-error ignore
            <PlateElement ref={ref} style={{...style, position: 'relative', width: 'fit-content'}} {...props}>
                {ghost}
                {children}
            </PlateElement>
        );
    });
