import {withRef} from '@udecode/cn';
import {PlateElement} from '@udecode/plate-common/react';
import * as React from 'react';


export const ParagraphElement = withRef<typeof PlateElement>(
    ({children, style, ...props}, ref) => {
        const ghost = React.useMemo(() => <span className='ghost' contentEditable={false}/>, []);
        return (
            // @ts-expect-error ignore
            <PlateElement ref={ref} style={{...style, position: 'relative'}} {...props}>
                {ghost}
                {children}
            </PlateElement>
        );
    });
