import {PlateLeaf, withRef} from '@udecode/plate-common/react';
import * as React from 'react';

export const HighlightLeaf = withRef<typeof PlateLeaf>(
    ({children, style, ...props}, ref) => (
        <PlateLeaf
            asChild
            style={{
                ...style,
                backgroundColor: 'rgba(15, 23, 42, 0.2)',
                color: 'inherit',
            }}
            // @ts-expect-error ignore
            ref={ref}
            {...props}
        >
            <mark>{children}</mark>
        </PlateLeaf>
    )
);
