import {HeaderPlugin, SectionPlugin} from '@plate/plugins/plate-pagination';
import {PlateElement, useElement, withRef} from '@udecode/plate-common/react';
import * as React from 'react';

export const HeaderFooterElement = withRef<typeof PlateElement>(
    ({children, ...props}, ref) => {
        const {type} = useElement(),
            {marginTop, marginBottom} = useElement(SectionPlugin.key),
            height = (type === HeaderPlugin.key ? marginTop : marginBottom) as number,
            ghost = React.useMemo(() => <span className='ghost' contentEditable={false}/>, []);

        return (
            // @ts-expect-error ignore
            <PlateElement ref={ref} {...props} style={{height: `${height}cm`, position: 'relative'}}>
                {ghost}
                {children}
            </PlateElement>
        );
    }
);
