@zk.WrapClass('kkdoc.Docpad')
export class Docpad extends zul.Widget {
    /** @internal */
    _plate?: kkdoc.PlateObject;
    /** @internal */
    _value?: TElement;
    /** @internal */
    _showMainToolbar?: boolean;
    /** @internal */
    _mainToolbarContainer?: zul.wgt.Div;
    /** @internal */
    _editorContainer?: zul.wgt.Div;
    /** @internal */
    _popupToolbarContainer?: zul.wgt.Popup;

    getValue(): TElement | undefined {
        return this._value;
    }

    setValue(value: TElement, opts?: Record<string, boolean>): this {
        const o = this._value;
        this._value = value;
        if (this.desktop && (o !== value || opts?.force)) {
            this._plate?.setValue(value);
        }
        return this;
    }

    setApply(apply: KOperation[]): this {
        this._plate?.applyOperation(apply);
        return this;
    }

    setShowMainToolbar(showMainToolbar: boolean): this {
        if (this._showMainToolbar !== showMainToolbar) {
            this._showMainToolbar = showMainToolbar;
            this._updateHeight();
        }
        return this;
    }

    /** @internal */
    _updateHeight(): void {
        if (this.desktop && this._mainToolbarContainer && this._editorContainer) {
            const docpadHeight = this.$n()!.offsetHeight,
                toolbarHeight = this._mainToolbarContainer.$n() !== undefined ? this._mainToolbarContainer.$n()!.offsetHeight : 0,
                editorHeight = docpadHeight - toolbarHeight;
            this._editorContainer.setHeight(editorHeight + 'px');
        }
    }

    override bind_(desktop?: zk.Desktop, skipper?: zk.Skipper, after?: CallableFunction[]): void {
        super.bind_(desktop, skipper, after); // TODO fix bind_ doesn't exist on Widget
        this._mainToolbarContainer = this.getChildAt(0) as zul.wgt.Div;
        this._editorContainer = this.getChildAt(1) as zul.wgt.Div;
        this._popupToolbarContainer = this.getChildAt(2) as zul.wgt.Popup;
        this._updateHeight();
        this._plate = new kkdoc.PlateObject(this.getChildAt(1)!.uuid, /*safe*/ this.getZclass(), this._value!,
            this._onChange.bind(this), this._onCopy.bind(this), this._onCut.bind(this), this._onPaste.bind(this),
            this._onEditorMouseUp.bind(this));
    }

    override unbind_(skipper?: zk.Skipper, after?: CallableFunction[], keepRod?: boolean): void {
        this._plate = undefined;
        this._mainToolbarContainer = this._editorContainer = this._popupToolbarContainer = undefined;
        super.unbind_(skipper, after, keepRod);
    }

    /** @internal */
    _onChange(operations: KOperation[]): void {
        this.fire('onChanging', {operations});
    }

    /** @internal */
    _onCopy(nodes: TElement[]): void {
        this.fire('onClipboardCopy', {nodes});
    }

    /** @internal */
    _onCut(nodes: TElement[]): void {
        this.fire('onClipboardCut', {nodes});
    }

    /** @internal */
    _onPaste(nodes: TElement[]): void {
        this.fire('onClipboardPaste', {nodes});
    }

    /** @internal */
    _onEditorMouseUp(): void {
        this.fire('onEditorMouseUp');
    }

    override focus_(timeout?: number): boolean {
        return !!this._plate?.focus() || false;
    }
}
