/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.doc.ui.toolbar;

import io.keikai.doc.api.editor.Commands;
import io.keikai.doc.api.editor.Editor;
import io.keikai.doc.api.editor.SelectionView;
import io.keikai.doc.api.impl.node.style.ParagraphStyle;
import io.keikai.doc.ui.Docpad;
import io.keikai.doc.ui.toolbar.ToolbarActionInserter;
import java.util.Arrays;
import org.zkoss.zk.ui.Component;
import org.zkoss.zul.Menuitem;
import org.zkoss.zul.Menupopup;
import org.zkoss.zul.Popup;
import org.zkoss.zul.Toolbar;
import org.zkoss.zul.Toolbarbutton;
import org.zkoss.zul.impl.LabelImageElement;

public class ParagraphSpacingInserter
implements ToolbarActionInserter {
    public static final String[] SPACINGS = new String[]{"1.0", "1.15", "1.5", "2.0", "2.5", "3.0"};

    @Override
    public void insertTool(Docpad docpad, Toolbar toolbar) {
        Editor editor = Editor.getInstance(docpad);
        Toolbarbutton btn = new Toolbarbutton();
        btn.setIconSclass("z-icon-text-height");
        btn.setTooltiptext("Paragraph Spacing");
        Menupopup pp = new Menupopup();
        btn.setPopupAttributes((Popup)pp, "after_start", null, null, "toggle");
        Arrays.stream(SPACINGS).forEach(s -> {
            Menuitem item = new Menuitem(s);
            item.addEventListener("onClick", e -> {
                editor.execute(Commands.findSelection().paragraphStyle(style -> style.withLineHeight(Double.parseDouble(s))));
                pp.getChildren().forEach(i -> ((LabelImageElement)i).setIconSclass(null));
                item.setIconSclass("z-icon-check");
            });
            pp.appendChild((Component)item);
        });
        docpad.addEventListener("onDocpadChange", e -> {
            if (!toolbar.getParent().isVisible()) {
                return;
            }
            SelectionView sv = editor.getSelection();
            if (sv == null) {
                return;
            }
            boolean allMatched = sv.allParagraphStyleMatched(ParagraphStyle::getLineHeight);
            String tar = String.valueOf(sv.getStartParagraphStyle(ParagraphStyle::getLineHeight));
            pp.getChildren().forEach(i -> {
                Menuitem mi = (Menuitem)i;
                mi.setIconSclass(allMatched && mi.getLabel().equals(tar) ? "z-icon-check" : "");
            });
        });
        toolbar.appendChild((Component)btn);
        toolbar.appendChild((Component)pp);
    }
}

