/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.doc.ui.toolbar;

import io.keikai.doc.api.editor.Commands;
import io.keikai.doc.api.editor.Editor;
import io.keikai.doc.api.editor.SelectionView;
import io.keikai.doc.api.impl.node.style.TextStyle;
import io.keikai.doc.ui.Docpad;
import io.keikai.doc.ui.toolbar.ToolbarActionInserter;
import java.util.Arrays;
import org.zkoss.zk.ui.Component;
import org.zkoss.zul.Combobox;
import org.zkoss.zul.Comboitem;
import org.zkoss.zul.Toolbar;

public class FontSizeInserter
implements ToolbarActionInserter {
    public static final String[] FONT_SIZES = new String[]{"8", "9", "10", "11", "12", "14", "16", "18", "20", "22", "24", "26", "28", "36", "48", "72"};

    @Override
    public void insertTool(Docpad docpad, Toolbar toolbar) {
        Editor editor = Editor.getInstance(docpad);
        Combobox cb = new Combobox();
        cb.setTooltiptext("Font Size");
        cb.setWidth("100px");
        Arrays.stream(FONT_SIZES).forEach(arg_0 -> ((Combobox)cb).appendItem(arg_0));
        cb.addEventListener("onOK", e -> {
            String f = cb.getValue();
            editor.execute(Commands.findSelection().textStyle(style -> style.withFontSize(Double.parseDouble(f))));
        });
        cb.addEventListener("onSelect", e -> {
            Comboitem selected = cb.getSelectedItem();
            if (selected == null) {
                return;
            }
            String f = selected.getLabel();
            editor.execute(Commands.findSelection().textStyle(style -> style.withFontSize(Integer.parseInt(f))));
        });
        cb.setSelectedIndex(4);
        docpad.addEventListener("onDocpadChange", e -> {
            if (!toolbar.getParent().isVisible()) {
                return;
            }
            SelectionView sv = editor.getSelection();
            if (sv == null) {
                return;
            }
            boolean allMatched = sv.allTextStylesMatched(TextStyle::getFontSize);
            if (allMatched) {
                double fs = sv.getStartTextNodeStyle(TextStyle::getFontSize);
                cb.setValue(fs == (double)((int)fs) ? String.valueOf((int)fs) : String.valueOf(fs));
            } else {
                cb.setValue("");
            }
        });
        toolbar.appendChild((Component)cb);
    }
}

