/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.doc.ui.toolbar;

import io.keikai.doc.api.editor.Commands;
import io.keikai.doc.api.editor.Editor;
import io.keikai.doc.api.editor.SelectionView;
import io.keikai.doc.api.impl.node.style.TextStyle;
import io.keikai.doc.ui.Docpad;
import io.keikai.doc.ui.toolbar.DocpadToolbarbutton;
import io.keikai.doc.ui.toolbar.ToolbarActionInserter;
import org.zkoss.zk.ui.Component;
import org.zkoss.zul.Toolbar;

public class FontItalicInserter
implements ToolbarActionInserter {
    @Override
    public void insertTool(Docpad docpad, Toolbar toolbar) {
        Editor editor = Editor.getInstance(docpad);
        DocpadToolbarbutton btn = new DocpadToolbarbutton();
        btn.setIconSclass("z-icon-italic");
        btn.setTooltiptext("Italic");
        btn.addEventListener("onClick", e -> {
            SelectionView sv = editor.getSelection();
            if (sv != null && sv.isRange()) {
                boolean allItalic = sv.allTextStylesMatched(TextStyle::isItalic);
                editor.execute(Commands.findSelection().textStyle(style -> style.withItalic(!allItalic)));
                btn.setMatched(!allItalic);
            }
        });
        docpad.addEventListener("onDocpadChange", e -> {
            if (!toolbar.getParent().isVisible()) {
                return;
            }
            SelectionView sv = editor.getSelection();
            if (sv == null) {
                return;
            }
            btn.setMatched(sv.allTextStylesMatched(TextStyle::isItalic));
        });
        toolbar.appendChild((Component)btn);
    }
}

