/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.doc.ui.toolbar;

import io.keikai.doc.api.editor.Commands;
import io.keikai.doc.api.editor.Editor;
import io.keikai.doc.api.editor.SelectionView;
import io.keikai.doc.api.impl.node.style.TextStyle;
import io.keikai.doc.ui.Docpad;
import io.keikai.doc.ui.toolbar.ToolbarActionInserter;
import java.util.Arrays;
import org.zkoss.zk.ui.Component;
import org.zkoss.zul.Combobox;
import org.zkoss.zul.Comboitem;
import org.zkoss.zul.Toolbar;

public class FontFamilyInserter
implements ToolbarActionInserter {
    public static final String[] FONTS = new String[]{"Times New Roman", "Georgia", "Arial", "Helvetica", "Verdana", "Tahoma", "Courier New", "Monaco", "Comic Sans MS", "Brush Script MT", "Impact", "Papyrus", "Trebuchet"};

    @Override
    public void insertTool(Docpad docpad, Toolbar toolbar) {
        Editor editor = Editor.getInstance(docpad);
        Combobox cb = new Combobox();
        cb.setReadonly(true);
        cb.setTooltiptext("Font Family");
        Arrays.stream(FONTS).forEach(f -> {
            Comboitem item = new Comboitem(f);
            item.setStyle("font-family:" + f + ";");
            cb.appendChild((Component)item);
        });
        cb.addEventListener("onSelect", e -> {
            Comboitem selected = cb.getSelectedItem();
            if (selected == null) {
                return;
            }
            String f = selected.getLabel();
            cb.setStyle("font-family:" + f + ";");
            editor.execute(Commands.findSelection().textStyle(style -> style.withFontFamily(f)));
        });
        cb.setSelectedIndex(0);
        docpad.addEventListener("onDocpadChange", e -> {
            if (!toolbar.getParent().isVisible()) {
                return;
            }
            SelectionView sv = editor.getSelection();
            if (sv == null) {
                return;
            }
            boolean allMatched = sv.allTextStylesMatched(TextStyle::getFontFamily);
            if (allMatched) {
                String f = sv.getStartTextNodeStyle(TextStyle::getFontFamily);
                cb.setStyle("font-family:" + f + ";");
                cb.setSelectedIndex(Arrays.asList(FONTS).indexOf(f));
            } else {
                cb.setValue("");
            }
        });
        toolbar.appendChild((Component)cb);
    }
}

