/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.doc.ui.toolbar;

import io.keikai.doc.api.editor.Commands;
import io.keikai.doc.api.editor.Editor;
import io.keikai.doc.api.editor.SelectionView;
import io.keikai.doc.api.impl.node.style.Color;
import io.keikai.doc.api.impl.node.style.TextStyle;
import io.keikai.doc.ui.Docpad;
import io.keikai.doc.ui.toolbar.ToolbarActionInserter;
import org.zkoss.zk.ui.Component;
import org.zkoss.zkex.zul.Colorbox;
import org.zkoss.zul.Toolbar;

public class FontColorInserter
implements ToolbarActionInserter {
    @Override
    public void insertTool(Docpad docpad, Toolbar toolbar) {
        Editor editor = Editor.getInstance(docpad);
        Colorbox colorbox = new Colorbox();
        colorbox.setTooltiptext("Font Color");
        colorbox.addEventListener("onChange", e -> {
            Color color = Color.decode(colorbox.getColor());
            editor.execute(Commands.findSelection().textStyle(style -> style.withColor(color)));
        });
        docpad.addEventListener("onDocpadChange", e -> {
            if (!toolbar.getParent().isVisible()) {
                return;
            }
            SelectionView sv = editor.getSelection();
            if (sv == null) {
                return;
            }
            boolean allMatched = sv.allTextStylesMatched(TextStyle::getColor);
            Color color = sv.getStartTextNodeStyle(TextStyle::getColor);
            String c = allMatched && color != null ? Color.toHexString(color) : "#FFFFFF";
            colorbox.setColor(c);
        });
        toolbar.appendChild((Component)colorbox);
    }
}

