/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.doc.ui.toolbar;

import io.keikai.doc.ui.toolbar.AlignInserter;
import io.keikai.doc.ui.toolbar.ExporterInserter;
import io.keikai.doc.ui.toolbar.FontBackgroundColorInserter;
import io.keikai.doc.ui.toolbar.FontBoldInserter;
import io.keikai.doc.ui.toolbar.FontColorInserter;
import io.keikai.doc.ui.toolbar.FontFamilyInserter;
import io.keikai.doc.ui.toolbar.FontItalicInserter;
import io.keikai.doc.ui.toolbar.FontSizeInserter;
import io.keikai.doc.ui.toolbar.FontStrikethroughInserter;
import io.keikai.doc.ui.toolbar.FontSubscriptInserter;
import io.keikai.doc.ui.toolbar.FontSuperscriptInserter;
import io.keikai.doc.ui.toolbar.FontUnderlineInserter;
import io.keikai.doc.ui.toolbar.ImporterInserter;
import io.keikai.doc.ui.toolbar.ParagraphDecreaseIndentInserter;
import io.keikai.doc.ui.toolbar.ParagraphIncreaseIndentInserter;
import io.keikai.doc.ui.toolbar.ParagraphSpacingInserter;
import io.keikai.doc.ui.toolbar.ParagraphTypeInserter;
import io.keikai.doc.ui.toolbar.RedoInserter;
import io.keikai.doc.ui.toolbar.SeparatorInserter;
import io.keikai.doc.ui.toolbar.ToolbarAction;
import io.keikai.doc.ui.toolbar.ToolbarActionInserter;
import io.keikai.doc.ui.toolbar.ToolbarManager;
import io.keikai.doc.ui.toolbar.UndoInserter;
import java.util.HashMap;
import java.util.Map;

public class DefaultToolbarManager
implements ToolbarManager {
    protected final Map<String, ToolbarActionInserter> _adderMap = new HashMap<String, ToolbarActionInserter>();

    public DefaultToolbarManager() {
        this.initDefaultInserters();
    }

    protected void initDefaultInserters() {
        this.registerInserter(ToolbarAction.SEPARATOR, (ToolbarActionInserter)new SeparatorInserter());
        this.registerInserter(ToolbarAction.UNDO, (ToolbarActionInserter)new UndoInserter());
        this.registerInserter(ToolbarAction.REDO, (ToolbarActionInserter)new RedoInserter());
        this.registerInserter(ToolbarAction.PARAGRAPH_TYPE, (ToolbarActionInserter)new ParagraphTypeInserter());
        this.registerInserter(ToolbarAction.FONT_FAMILY, (ToolbarActionInserter)new FontFamilyInserter());
        this.registerInserter(ToolbarAction.FONT_SIZE, (ToolbarActionInserter)new FontSizeInserter());
        this.registerInserter(ToolbarAction.FONT_BOLD, (ToolbarActionInserter)new FontBoldInserter());
        this.registerInserter(ToolbarAction.FONT_ITALIC, (ToolbarActionInserter)new FontItalicInserter());
        this.registerInserter(ToolbarAction.FONT_UNDERLINE, (ToolbarActionInserter)new FontUnderlineInserter());
        this.registerInserter(ToolbarAction.FONT_STRIKETHROUGH, (ToolbarActionInserter)new FontStrikethroughInserter());
        this.registerInserter(ToolbarAction.FONT_SUPERSCRIPT, (ToolbarActionInserter)new FontSuperscriptInserter());
        this.registerInserter(ToolbarAction.FONT_SUBSCRIPT, (ToolbarActionInserter)new FontSubscriptInserter());
        this.registerInserter(ToolbarAction.FONT_COLOR, (ToolbarActionInserter)new FontColorInserter());
        this.registerInserter(ToolbarAction.FONT_BACKGROUND_COLOR, (ToolbarActionInserter)new FontBackgroundColorInserter());
        this.registerInserter(ToolbarAction.ALIGN, (ToolbarActionInserter)new AlignInserter());
        this.registerInserter(ToolbarAction.PARAGRAPH_SPACING, (ToolbarActionInserter)new ParagraphSpacingInserter());
        this.registerInserter(ToolbarAction.PARAGRAPH_DECREASE_INDENT, (ToolbarActionInserter)new ParagraphDecreaseIndentInserter());
        this.registerInserter(ToolbarAction.PARAGRAPH_INCREASE_INDENT, (ToolbarActionInserter)new ParagraphIncreaseIndentInserter());
        this.registerInserter(ToolbarAction.IMPORTER, (ToolbarActionInserter)new ImporterInserter());
        this.registerInserter(ToolbarAction.EXPORTER, (ToolbarActionInserter)new ExporterInserter());
    }

    @Override
    public void registerInserter(String tool, ToolbarActionInserter toolbarActionInserter) {
        this._adderMap.put(tool, toolbarActionInserter);
    }

    @Override
    public void registerInserter(ToolbarAction toolbarAction, ToolbarActionInserter toolbarActionInserter) {
        this.registerInserter(toolbarAction.toString(), toolbarActionInserter);
    }

    @Override
    public ToolbarActionInserter getInserter(String tool) {
        return this._adderMap.get(tool);
    }
}

