/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.doc.ui.toolbar;

import io.keikai.doc.api.editor.Commands;
import io.keikai.doc.api.editor.Editor;
import io.keikai.doc.api.editor.SelectionView;
import io.keikai.doc.api.impl.node.style.ParagraphStyle;
import io.keikai.doc.ui.Docpad;
import io.keikai.doc.ui.toolbar.ToolbarActionInserter;
import java.util.Arrays;
import org.zkoss.zk.ui.Component;
import org.zkoss.zul.Menuitem;
import org.zkoss.zul.Menupopup;
import org.zkoss.zul.Popup;
import org.zkoss.zul.Toolbar;
import org.zkoss.zul.Toolbarbutton;

public class AlignInserter
implements ToolbarActionInserter {
    @Override
    public void insertTool(Docpad docpad, Toolbar toolbar) {
        Editor editor = Editor.getInstance(docpad);
        Toolbarbutton btn = new Toolbarbutton();
        btn.setIconSclass("z-icon-align-left");
        btn.setTooltiptext("Align");
        Menupopup pp = new Menupopup();
        btn.setPopupAttributes((Popup)pp, "after_start", null, null, "toggle");
        Arrays.stream(ParagraphStyle.Align.values()).forEach(v -> {
            Menuitem item = new Menuitem();
            String iconSclass = "z-icon-align-" + v.toString().toLowerCase();
            item.setIconSclass(iconSclass);
            item.setTooltiptext(v + " align");
            item.addEventListener("onClick", e -> {
                editor.execute(Commands.findSelection().paragraphStyle(style -> style.withAlign((ParagraphStyle.Align)((Object)v))));
                btn.setIconSclass(iconSclass);
            });
            pp.appendChild((Component)item);
        });
        docpad.addEventListener("onDocpadChange", e -> {
            if (!toolbar.getParent().isVisible()) {
                return;
            }
            SelectionView sv = editor.getSelection();
            if (sv == null) {
                return;
            }
            String iconSclass = "z-icon-align-" + sv.getStartParagraphStyle(ParagraphStyle::getAlign).toString().toLowerCase();
            btn.setIconSclass(iconSclass);
        });
        toolbar.appendChild((Component)btn);
        toolbar.appendChild((Component)pp);
    }
}

