/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.doc.api.impl.operation;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.keikai.doc.api.DocumentModel;
import io.keikai.doc.api.Path;
import io.keikai.doc.api.impl.node.TextNode;
import io.keikai.doc.api.impl.operation.AbstractDocumentOperation;
import io.keikai.doc.api.impl.operation.AddTextOperation;

public class RemoveTextOperation
extends AbstractDocumentOperation {
    static final String TYPE = "REMOVE_TEXT";
    private final int _offset;
    private final String _text;

    @JsonCreator
    public RemoveTextOperation(@JsonProperty(value="path") Path path, @JsonProperty(value="offset") int offset, @JsonProperty(value="text") String text) {
        super(TYPE, path);
        this._offset = offset;
        this._text = text;
    }

    public int getOffset() {
        return this._offset;
    }

    public String getText() {
        return this._text;
    }

    @Override
    public void apply(DocumentModel model) {
        TextNode span = (TextNode)model.getNode(this.getPath());
        span.removeText(this._offset, this._offset + this._text.length());
    }

    @Override
    public AbstractDocumentOperation reverse() {
        return new AddTextOperation(this.getPath(), this._offset, this._text);
    }
}

