/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.doc.api.impl.operation;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.keikai.doc.api.DocumentModel;
import io.keikai.doc.api.Path;
import io.keikai.doc.api.impl.node.AbstractDocumentNode;
import io.keikai.doc.api.impl.operation.AbstractDocumentOperation;
import io.keikai.doc.api.impl.operation.SplitChildOperation;
import java.util.Map;

public class MergeChildOperation
extends AbstractDocumentOperation {
    static final String TYPE = "MERGE_NODE";
    private final int _position;
    private final Map<Object, Object> _properties;

    @JsonCreator
    public MergeChildOperation(@JsonProperty(value="path") Path path, @JsonProperty(value="position") int position, @JsonProperty(value="properties") Map<Object, Object> properties) {
        super(TYPE, path);
        this._position = position;
        this._properties = properties;
    }

    public int getPosition() {
        return this._position;
    }

    public Map<Object, Object> getProperties() {
        return this._properties;
    }

    @Override
    public void apply(DocumentModel model) {
        AbstractDocumentNode parent = (AbstractDocumentNode)model.getNode(this.getPath().getParent());
        parent.mergeChildToPreviousChild(this.getPath().getLastIndex());
    }

    @Override
    public AbstractDocumentOperation reverse() {
        return new SplitChildOperation(this.getPath().getPreviousSibling(), this._position, this._properties);
    }
}

