/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.doc.api.impl.operation;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.keikai.doc.api.DocumentOperation;
import io.keikai.doc.api.DocumentOperationBatch;
import io.keikai.doc.api.impl.operation.DefaultDocumentOperationFactory;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class DefaultDocumentOperationBatch
implements DocumentOperationBatch {
    private final Instant _timestamp;
    private final boolean _fromClient;
    private final List<DocumentOperation> _operations = new ArrayList<DocumentOperation>();

    public DefaultDocumentOperationBatch() {
        this(false);
    }

    public DefaultDocumentOperationBatch(boolean fromClient) {
        this._timestamp = Instant.now();
        this._fromClient = fromClient;
    }

    @JsonCreator
    private DefaultDocumentOperationBatch(@JsonProperty(value="timestamp") Instant timestamp, @JsonProperty(value="fromClient") boolean fromClient, @JsonProperty(value="operations") List<Map<?, ?>> operations) {
        this._timestamp = timestamp;
        this._fromClient = fromClient;
        operations.forEach(operation -> this._operations.add(DefaultDocumentOperationFactory.create(operation)));
    }

    @Override
    public Instant getTimestamp() {
        return this._timestamp;
    }

    @Override
    public boolean isFromClient() {
        return this._fromClient;
    }

    @Override
    public List<DocumentOperation> getOperations() {
        return Collections.unmodifiableList(this._operations);
    }

    @Override
    public void addOperation(DocumentOperation operation) {
        this._operations.add(operation);
    }

    @Override
    public void addAllOperations(DocumentOperationBatch batch) {
        this._operations.addAll(batch.getOperations());
    }

    @Override
    public void removeOperation(DocumentOperation operation) {
        this._operations.remove(operation);
    }
}

