/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.doc.api.impl.node.style;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.keikai.doc.api.impl.node.style.AbstractDocumentNodeStyle;

public class SectionStyle
extends AbstractDocumentNodeStyle {
    public static final SectionStyle DEFAULT;
    private static boolean defaultInitialized;
    private final double _pageHeight;
    private final double _pageWidth;
    private final double _marginTop;
    private final double _marginRight;
    private final double _marginBottom;
    private final double _marginLeft;

    @JsonCreator
    private SectionStyle(@JsonProperty(value="pageHeight") Double pageHeight, @JsonProperty(value="pageWidth") Double pageWidth, @JsonProperty(value="marginTop") Double marginTop, @JsonProperty(value="marginRight") Double marginRight, @JsonProperty(value="marginBottom") Double marginBottom, @JsonProperty(value="marginLeft") Double marginLeft) {
        this._pageHeight = pageHeight == null && defaultInitialized ? SectionStyle.DEFAULT._pageHeight : pageHeight;
        this._pageWidth = pageWidth == null && defaultInitialized ? SectionStyle.DEFAULT._pageWidth : pageWidth;
        this._marginTop = marginTop == null && defaultInitialized ? SectionStyle.DEFAULT._marginTop : marginTop;
        this._marginRight = marginRight == null && defaultInitialized ? SectionStyle.DEFAULT._marginRight : marginRight;
        this._marginBottom = marginBottom == null && defaultInitialized ? SectionStyle.DEFAULT._marginBottom : marginBottom;
        this._marginLeft = marginLeft == null && defaultInitialized ? SectionStyle.DEFAULT._marginLeft : marginLeft;
    }

    public double getPageHeight() {
        return this._pageHeight;
    }

    public SectionStyle withPageHeight(double pageHeight) {
        return new Builder(this).setPageHeight(pageHeight).build();
    }

    public double getPageWidth() {
        return this._pageWidth;
    }

    public SectionStyle withPageWidth(double pageWidth) {
        return new Builder(this).setPageWidth(pageWidth).build();
    }

    public double getMarginTop() {
        return this._marginTop;
    }

    public SectionStyle withMarginTop(double marginTop) {
        return new Builder(this).setMarginTop(marginTop).build();
    }

    public double getMarginRight() {
        return this._marginRight;
    }

    public SectionStyle withMarginRight(double marginRight) {
        return new Builder(this).setMarginRight(marginRight).build();
    }

    public double getMarginBottom() {
        return this._marginBottom;
    }

    public SectionStyle withMarginBottom(double marginBottom) {
        return new Builder(this).setMarginBottom(marginBottom).build();
    }

    public double getMarginLeft() {
        return this._marginLeft;
    }

    public SectionStyle withMarginLeft(double marginLeft) {
        return new Builder(this).setMarginLeft(marginLeft).build();
    }

    static {
        defaultInitialized = false;
        DEFAULT = new Builder().build();
        defaultInitialized = true;
    }

    public static class Builder {
        private double _pageHeight = 29.7;
        private double _pageWidth = 20.99;
        private double _marginTop = 2.54;
        private double _marginRight = 2.54;
        private double _marginBottom = 2.54;
        private double _marginLeft = 2.54;

        public Builder() {
        }

        Builder(SectionStyle style) {
            this._pageHeight = style._pageHeight;
            this._pageWidth = style._pageWidth;
            this._marginTop = style._marginTop;
            this._marginRight = style._marginRight;
            this._marginBottom = style._marginBottom;
            this._marginLeft = style._marginLeft;
        }

        public Builder setPageHeight(double pageHeight) {
            this._pageHeight = pageHeight;
            return this;
        }

        public Builder setPageWidth(double pageWidth) {
            this._pageWidth = pageWidth;
            return this;
        }

        public Builder setMarginTop(double marginTop) {
            this._marginTop = marginTop;
            return this;
        }

        public Builder setMarginRight(double marginRight) {
            this._marginRight = marginRight;
            return this;
        }

        public Builder setMarginBottom(double marginBottom) {
            this._marginBottom = marginBottom;
            return this;
        }

        public Builder setMarginLeft(double marginLeft) {
            this._marginLeft = marginLeft;
            return this;
        }

        public SectionStyle build() {
            return new SectionStyle(this._pageHeight, this._pageWidth, this._marginTop, this._marginRight, this._marginBottom, this._marginLeft);
        }
    }
}

