/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.doc.api.impl.node.style;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.keikai.doc.api.impl.node.style.AbstractDocumentNodeStyle;

public class ParagraphStyle
extends AbstractDocumentNodeStyle {
    public static final ParagraphStyle DEFAULT;
    private static boolean defaultInitialized;
    private final Type _type;
    private final Align _align;
    private final int _indent;
    private final double _lineHeight;

    @JsonCreator
    private ParagraphStyle(@JsonProperty(value="type") Type type, @JsonProperty(value="align") Align align, @JsonProperty(value="indent") Integer indent, @JsonProperty(value="lineHeight") Double lineHeight) {
        this._type = type == null && defaultInitialized ? ParagraphStyle.DEFAULT._type : type;
        this._align = align == null && defaultInitialized ? ParagraphStyle.DEFAULT._align : align;
        this._indent = indent == null && defaultInitialized ? ParagraphStyle.DEFAULT._indent : indent;
        this._lineHeight = lineHeight == null && defaultInitialized ? ParagraphStyle.DEFAULT._lineHeight : lineHeight;
    }

    public Type getType() {
        return this._type;
    }

    public ParagraphStyle withType(Type type) {
        return new Builder(this).setType(type).build();
    }

    public Align getAlign() {
        return this._align;
    }

    public ParagraphStyle withAlign(Align align) {
        return new Builder(this).setAlign(align).build();
    }

    public int getIndent() {
        return this._indent;
    }

    public ParagraphStyle withIndent(int indent) {
        return new Builder(this).setIndent(indent).build();
    }

    public double getLineHeight() {
        return this._lineHeight;
    }

    public ParagraphStyle withLineHeight(double lineHeight) {
        return new Builder(this).setLineHeight(lineHeight).build();
    }

    static {
        defaultInitialized = false;
        DEFAULT = new Builder().build();
        defaultInitialized = true;
    }

    public static class Builder {
        private Type _type = Type.P;
        private Align _align = Align.LEFT;
        private int _indent = 0;
        private double _lineHeight = 1.0;

        public Builder() {
        }

        Builder(ParagraphStyle style) {
            this._type = style._type;
            this._align = style._align;
            this._indent = style._indent;
            this._lineHeight = style._lineHeight;
        }

        public Builder setType(Type type) {
            this._type = type;
            return this;
        }

        public Builder setAlign(Align align) {
            this._align = align;
            return this;
        }

        public Builder setIndent(int indent) {
            this._indent = indent;
            return this;
        }

        public Builder setLineHeight(double lineHeight) {
            this._lineHeight = lineHeight;
            return this;
        }

        public ParagraphStyle build() {
            return new ParagraphStyle(this._type, this._align, this._indent, this._lineHeight);
        }
    }

    public static enum Align {
        LEFT,
        CENTER,
        RIGHT,
        JUSTIFY;


        @JsonValue
        public String toString() {
            return super.toString().toLowerCase();
        }

        @JsonCreator
        private static Align fromString(String value) {
            return value == null ? null : Align.valueOf(value.toUpperCase());
        }
    }

    public static enum Type {
        P(16.0),
        H1(32.0),
        H2(24.0),
        H3(18.72),
        H4(16.0),
        H5(13.28),
        H6(10.72);

        private final double _fontSize;

        private Type(double fontSize) {
            this._fontSize = fontSize;
        }

        public double getFontSize() {
            return this._fontSize;
        }

        @JsonValue
        public String toString() {
            return super.toString().toLowerCase();
        }

        @JsonCreator
        private static Type fromString(String value) {
            return value == null ? null : Type.valueOf(value.toUpperCase());
        }
    }
}

