/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.doc.api.impl.node.style;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.keikai.doc.api.impl.node.AbstractDocumentNode;
import io.keikai.doc.api.impl.node.ParagraphNode;
import io.keikai.doc.api.impl.node.style.AbstractDocumentNodeStyle;
import java.lang.reflect.Field;

public class ComponentStyle
extends AbstractDocumentNodeStyle {
    public static final ComponentStyle DEFAULT;
    private static boolean defaultInitialized;
    private final boolean _deletable;
    private final double _width;
    private final double _height;
    private final TextWrap _textWrap;
    private final Class<? extends AbstractDocumentNode<?, ?, ?>> _offsetParentClass;
    private final Position _position;
    private final Double _left;
    private final Double _top;

    @JsonCreator
    private ComponentStyle(@JsonProperty(value="deletable") Boolean deletable, @JsonProperty(value="width") Double width, @JsonProperty(value="height") Double height, @JsonProperty(value="textWrap") TextWrap textWrap, @JsonProperty(value="offsetParentClass") Class<? extends AbstractDocumentNode<?, ?, ?>> offsetParentClass, @JsonProperty(value="position") Position position, @JsonProperty(value="left") Double left, @JsonProperty(value="top") Double top) {
        this._deletable = deletable == null && defaultInitialized ? ComponentStyle.DEFAULT._deletable : deletable;
        this._width = width == null && defaultInitialized ? ComponentStyle.DEFAULT._width : width;
        this._height = height == null && defaultInitialized ? ComponentStyle.DEFAULT._height : height;
        this._textWrap = textWrap == null && defaultInitialized ? ComponentStyle.DEFAULT._textWrap : textWrap;
        this._offsetParentClass = offsetParentClass == null && defaultInitialized ? ComponentStyle.DEFAULT._offsetParentClass : offsetParentClass;
        this._position = position == null && defaultInitialized ? ComponentStyle.DEFAULT._position : position;
        this._left = left == null && defaultInitialized ? ComponentStyle.DEFAULT._left : left;
        this._top = top == null && defaultInitialized ? ComponentStyle.DEFAULT._top : top;
    }

    public boolean isDeletable() {
        return this._deletable;
    }

    public ComponentStyle withDeletable(boolean deletable) {
        return new Builder(this).setDeletable(deletable).build();
    }

    public double getWidth() {
        return this._width;
    }

    public ComponentStyle withWidth(double width) {
        return new Builder(this).setWidth(width).build();
    }

    public double getHeight() {
        return this._height;
    }

    public ComponentStyle withHeight(double height) {
        return new Builder(this).setHeight(height).build();
    }

    public TextWrap getTextWrap() {
        return this._textWrap;
    }

    public ComponentStyle withTextWrap(TextWrap textWrap) {
        return new Builder(this).setTextWrap(textWrap).build();
    }

    public Class<? extends AbstractDocumentNode<?, ?, ?>> getOffsetParentClass() {
        return this._offsetParentClass;
    }

    public ComponentStyle withOffsetParentClass(Class<? extends AbstractDocumentNode<?, ?, ?>> offsetParentClass) {
        return new Builder(this).setOffsetParentClass(offsetParentClass).build();
    }

    @JsonProperty(value="offsetParentType")
    private String getOffsetParentType() {
        try {
            if (this._offsetParentClass == null) {
                return null;
            }
            Field field = this._offsetParentClass.getDeclaredField("TYPE");
            field.setAccessible(true);
            return (String)field.get(null);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            return null;
        }
    }

    public Position getPosition() {
        return this._position;
    }

    public ComponentStyle withPosition(Position position) {
        return new Builder(this).setPosition(position).build();
    }

    public Double getLeft() {
        return this._left;
    }

    public ComponentStyle withLeft(double left) {
        return new Builder(this).setLeft(left).build();
    }

    public Double getTop() {
        return this._top;
    }

    public ComponentStyle withTop(double top) {
        return new Builder(this).setTop(top).build();
    }

    static {
        defaultInitialized = false;
        DEFAULT = new Builder().build();
        defaultInitialized = true;
    }

    public static class Builder {
        private boolean _deletable = true;
        private double _width = -1.0;
        private double _height = -1.0;
        private TextWrap _textWrap = TextWrap.INLINE;
        private Class<? extends AbstractDocumentNode<?, ?, ?>> _offsetParentClass;
        private Position _position;
        private Double _top = null;
        private Double _left = null;

        public Builder() {
        }

        private Builder(ComponentStyle style) {
            this._deletable = style._deletable;
            this._width = style._width;
            this._height = style._height;
            this._textWrap = style._textWrap;
            this._offsetParentClass = style._offsetParentClass;
            this._position = style._position;
            this._top = style._top;
            this._left = style._left;
        }

        public Builder setDeletable(boolean deletable) {
            this._deletable = deletable;
            return this;
        }

        public Builder setWidth(double width) {
            this._width = width;
            return this;
        }

        public Builder setHeight(double height) {
            this._height = height;
            return this;
        }

        public Builder setTextWrap(TextWrap textWrap) {
            this._textWrap = textWrap;
            if (TextWrap.BEHIND_TEXT.equals((Object)textWrap) || TextWrap.IN_FRONT_OF_TEXT.equals((Object)textWrap)) {
                if (this._offsetParentClass == null) {
                    this._offsetParentClass = ParagraphNode.class;
                }
                if (this._position == null && this._top == null && this._left == null) {
                    this._position = Position.TOP_LEFT;
                }
            }
            return this;
        }

        public Builder setOffsetParentClass(Class<? extends AbstractDocumentNode<?, ?, ?>> offsetParentClass) {
            this._offsetParentClass = offsetParentClass;
            return this;
        }

        public Builder setPosition(Position position) {
            this._position = position;
            this._left = null;
            this._top = null;
            return this;
        }

        public Builder setLeft(double left) {
            this._left = left;
            if (this._top == null) {
                this._top = 0.0;
            }
            this._position = null;
            return this;
        }

        public Builder setTop(double top) {
            this._top = top;
            if (this._left == null) {
                this._left = 0.0;
            }
            this._position = null;
            return this;
        }

        public ComponentStyle build() {
            return new ComponentStyle(this._deletable, this._width, this._height, this._textWrap, this._offsetParentClass, this._position, this._left, this._top);
        }
    }

    public static enum Position {
        BEFORE_START,
        BEFORE_CENTER,
        BEFORE_END,
        AFTER_START,
        AFTER_CENTER,
        AFTER_END,
        START_BEFORE,
        START_CENTER,
        START_AFTER,
        END_BEFORE,
        END_CENTER,
        END_AFTER,
        TOP_LEFT,
        TOP_CENTER,
        TOP_RIGHT,
        MIDDLE_LEFT,
        MIDDLE_CENTER,
        MIDDLE_RIGHT,
        BOTTOM_LEFT,
        BOTTOM_CENTER,
        BOTTOM_RIGHT;


        @JsonValue
        public String toString() {
            return super.toString().toLowerCase();
        }

        @JsonCreator
        private static Position fromString(String name) {
            return Position.valueOf(name.toUpperCase());
        }
    }

    public static enum TextWrap {
        INLINE,
        BREAK_TEXT,
        BEHIND_TEXT,
        IN_FRONT_OF_TEXT;


        @JsonValue
        public String toString() {
            return super.toString().toLowerCase();
        }

        @JsonCreator
        private static TextWrap fromString(String name) {
            return TextWrap.valueOf(name.toUpperCase());
        }
    }
}

