/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.doc.api.impl.node;

import io.keikai.doc.api.impl.model.DefaultDocumentModel;
import io.keikai.doc.api.impl.node.BlockNode;
import io.keikai.doc.api.impl.node.DocumentNodeLazyIterator;
import io.keikai.doc.api.impl.node.DocumentNodeVisitor;
import io.keikai.doc.api.impl.node.InlineNode;
import io.keikai.doc.api.impl.node.TextNode;
import io.keikai.doc.api.impl.node.style.ParagraphStyle;
import io.keikai.doc.api.impl.node.style.TextStyle;
import java.util.Collection;
import java.util.List;

public class ParagraphNode
extends BlockNode<InlineNode<?>, ParagraphStyle> {
    public ParagraphNode() {
        this(new ParagraphStyle.Builder().setType(ParagraphStyle.Type.P).build());
    }

    public ParagraphNode(ParagraphStyle style) {
        super(style);
    }

    public ParagraphNode(Collection<InlineNode<?>> children) {
        this(new ParagraphStyle.Builder().setType(ParagraphStyle.Type.P).build(), children);
    }

    public ParagraphNode(ParagraphStyle style, Collection<InlineNode<?>> children) {
        super(style, children);
    }

    public ParagraphNode(String text) {
        this((Collection<InlineNode<?>>)List.of(new TextNode(text)));
    }

    @Override
    String getType() {
        return ((ParagraphStyle)this.getStyle()).getType().toString();
    }

    @Override
    public <R> R accept(DocumentNodeVisitor<R> visitor) {
        return visitor.visit(this);
    }

    @Override
    public void setStyle(ParagraphStyle style) {
        DefaultDocumentModel model = this.getModel();
        Runnable r = () -> {
            ParagraphStyle oriStyle = (ParagraphStyle)this.getStyle();
            super.setStyle(style);
            ParagraphStyle.Type type = style.getType();
            if (oriStyle == null && !ParagraphStyle.Type.P.equals((Object)type) || oriStyle != null && !oriStyle.getType().equals((Object)style.getType())) {
                new DocumentNodeLazyIterator(this).stream().filter(TextNode.class::isInstance).map(TextNode.class::cast).forEach(textNode -> {
                    TextStyle newStyle = ((TextStyle)textNode.getStyle()).withFontSize(type.getFontSize());
                    textNode.setStyle(newStyle);
                });
            }
        };
        if (model == null) {
            r.run();
        } else {
            model.runBatch(r);
        }
    }
}

