/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.doc.api.impl.node;

import io.keikai.doc.api.DocumentNode;
import io.keikai.doc.api.DocumentRange;
import io.keikai.doc.api.Path;
import io.keikai.doc.api.impl.model.DefaultDocumentModel;
import io.keikai.doc.api.impl.node.ContainerNode;
import io.keikai.doc.api.impl.node.DocumentNodeLazyIterator;
import io.keikai.doc.api.impl.node.SectionNode;
import io.keikai.doc.api.impl.node.TextNode;
import java.util.stream.Stream;

public class DefaultDocumentRange
implements DocumentRange {
    private TextNode _startNode;
    private int _startOffset;
    private TextNode _endNode;
    private int _endOffset;

    public DefaultDocumentRange(TextNode startNode, int startOffset, TextNode endNode, int endOffset) {
        this._startNode = startNode;
        this._startOffset = startOffset;
        this._endNode = endNode;
        this._endOffset = endOffset;
    }

    public TextNode getStartNode() {
        return this._startNode;
    }

    @Override
    public int getStartOffset() {
        return this._startOffset;
    }

    public TextNode getEndNode() {
        return this._endNode;
    }

    @Override
    public int getEndOffset() {
        return this._endOffset;
    }

    void setStart(TextNode startNode, int startOffset) {
        this._startNode = startNode;
        this._startOffset = startOffset;
    }

    void setEnd(TextNode endNode, int endOffset) {
        this._endNode = endNode;
        this._endOffset = endOffset;
    }

    public Stream<DocumentNode<?, ?, ?>> getNodes() {
        SectionNode sectionNode;
        DefaultDocumentModel model = this._startNode.getModel();
        if (model == null) {
            return Stream.of(new DocumentNode[0]);
        }
        Path startNodePath = model.getPath(this._startNode);
        Path endNodePath = model.getPath(this._endNode);
        ContainerNode root = sectionNode = (SectionNode)model.getRoot().getChild(startNodePath.getSectionIndex());
        if (startNodePath.isInHeader()) {
            root = sectionNode.getHeader(startNodePath.getPageType());
        } else if (startNodePath.isInFooter()) {
            root = sectionNode.getFooter(startNodePath.getPageType());
        }
        return new DocumentNodeLazyIterator(root).stream().filter(node -> {
            Path path = model.getPath((DocumentNode<?, ?, ?>)node);
            return startNodePath.compareTo(path) <= 0 && path.compareTo(endNodePath) <= 0;
        });
    }
}

