/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.doc.api.impl.node;

import io.keikai.doc.api.impl.node.AbstractDocumentNode;
import io.keikai.doc.api.impl.node.BlockNode;
import io.keikai.doc.api.impl.node.ComponentNode;
import io.keikai.doc.api.impl.node.FooterNode;
import io.keikai.doc.api.impl.node.HeaderNode;
import io.keikai.doc.api.impl.node.HorizontalRuleNode;
import io.keikai.doc.api.impl.node.InlineNode;
import io.keikai.doc.api.impl.node.PageBreakNode;
import io.keikai.doc.api.impl.node.PageNumberNode;
import io.keikai.doc.api.impl.node.ParagraphNode;
import io.keikai.doc.api.impl.node.RootNode;
import io.keikai.doc.api.impl.node.SectionNode;
import io.keikai.doc.api.impl.node.TableCellNode;
import io.keikai.doc.api.impl.node.TableNode;
import io.keikai.doc.api.impl.node.TableRowNode;
import io.keikai.doc.api.impl.node.TextNode;
import io.keikai.doc.api.impl.node.style.AbstractDocumentNodeStyle;
import io.keikai.doc.api.impl.node.style.ComponentStyle;
import io.keikai.doc.api.impl.node.style.DefaultDocumentNodeStyleFactory;
import io.keikai.doc.api.impl.node.style.ParagraphStyle;
import io.keikai.doc.api.impl.node.style.SectionStyle;
import io.keikai.doc.api.impl.node.style.TableCellStyle;
import io.keikai.doc.api.impl.node.style.TableRowStyle;
import io.keikai.doc.api.impl.node.style.TableStyle;
import io.keikai.doc.api.impl.node.style.TextStyle;
import io.keikai.doc.api.impl.util.ObjectMapperUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.zkoss.zk.ui.Component;

public class DefaultDocumentNodeFactory {
    private DefaultDocumentNodeFactory() {
    }

    public static AbstractDocumentNode<?, ?, ?> create(Map<?, ?> map) {
        AbstractDocumentNodeStyle style;
        AbstractDocumentNode node = null;
        Object attributes = map.get("attributes");
        if (map.get("type") == null) {
            style = DefaultDocumentNodeStyleFactory.create(map, TextNode.class);
            node = new TextNode((TextStyle)style, (String)map.get("text"));
        }
        if (node == null) {
            List children = map.get("children") instanceof List ? ((List)map.get("children")).stream().map(o -> DefaultDocumentNodeFactory.create((Map)o)).collect(Collectors.toList()) : Collections.emptyList();
            switch (((String)map.get("type")).toLowerCase()) {
                case "root": {
                    node = new RootNode((Collection<SectionNode>)DefaultDocumentNodeFactory.castToList(children, SectionNode.class));
                    break;
                }
                case "section": {
                    style = DefaultDocumentNodeStyleFactory.create(map, SectionNode.class);
                    node = new SectionNode((SectionStyle)style, (Collection<BlockNode<?, ?>>)DefaultDocumentNodeFactory.castToBlockNodes(children));
                    break;
                }
                case "table": {
                    style = DefaultDocumentNodeStyleFactory.create(map, TableNode.class);
                    node = new TableNode((TableStyle)style, (Collection<TableRowNode>)DefaultDocumentNodeFactory.castToList(children, TableRowNode.class));
                    break;
                }
                case "tr": {
                    style = DefaultDocumentNodeStyleFactory.create(map, TableRowNode.class);
                    node = new TableRowNode((TableRowStyle)style, (Collection<TableCellNode>)DefaultDocumentNodeFactory.castToList(children, TableCellNode.class));
                    break;
                }
                case "td": {
                    style = DefaultDocumentNodeStyleFactory.create(map, TableCellNode.class);
                    node = new TableCellNode((TableCellStyle)style, (Collection<BlockNode<?, ?>>)DefaultDocumentNodeFactory.castToBlockNodes(children));
                    break;
                }
                case "page-break": {
                    node = new PageBreakNode(map.containsKey("auto"));
                    break;
                }
                case "header": {
                    node = new HeaderNode((Collection<BlockNode<?, ?>>)DefaultDocumentNodeFactory.castToBlockNodes(children));
                    break;
                }
                case "footer": {
                    node = new FooterNode((Collection<BlockNode<?, ?>>)DefaultDocumentNodeFactory.castToBlockNodes(children));
                    break;
                }
                case "page-number": {
                    node = new PageNumberNode();
                    break;
                }
                case "hr": {
                    node = new HorizontalRuleNode();
                    break;
                }
                case "component": {
                    Object componentAsByteArray = map.get("component");
                    if (!(componentAsByteArray instanceof byte[])) {
                        return null;
                    }
                    try (ByteArrayInputStream bis = new ByteArrayInputStream((byte[])componentAsByteArray);
                         ObjectInputStream ois = new ObjectInputStream(bis);){
                        style = DefaultDocumentNodeStyleFactory.create(map, ComponentNode.class);
                        node = new ComponentNode((Component)ois.readObject(), (ComponentStyle)style);
                        break;
                    }
                    catch (IOException | ClassNotFoundException e) {
                        return null;
                    }
                }
                default: {
                    style = DefaultDocumentNodeStyleFactory.create(map, ParagraphNode.class);
                    node = new ParagraphNode((ParagraphStyle)style, (Collection<InlineNode<?>>)DefaultDocumentNodeFactory.castToInlineNodes(children));
                }
            }
        }
        if (attributes instanceof Map) {
            node.setAttributes((Map)attributes);
        }
        return node;
    }

    public static <N extends AbstractDocumentNode<?, ?, ?>> N clone(N node) {
        AbstractDocumentNode<?, ?, ?> r = DefaultDocumentNodeFactory.create(ObjectMapperUtil.toJSON(node));
        r.setServerOnlyAttributes(new HashMap<Object, Object>(node.getServerOnlyAttributes()));
        return (N)r;
    }

    private static <T> List<T> castToList(List<?> list, Class<T> clazz) {
        return list.stream().map(clazz::cast).collect(Collectors.toList());
    }

    private static List<BlockNode<?, ?>> castToBlockNodes(List<?> list) {
        return list.stream().map(o -> (BlockNode)o).collect(Collectors.toList());
    }

    private static List<InlineNode<?>> castToInlineNodes(List<?> list) {
        return list.stream().map(o -> (InlineNode)o).collect(Collectors.toList());
    }
}

