/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.doc.api.impl.node;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.keikai.doc.api.impl.model.DefaultDocumentModel;
import io.keikai.doc.api.impl.node.DocumentNodeVisitor;
import io.keikai.doc.api.impl.node.InlineNode;
import io.keikai.doc.api.impl.node.ParagraphNode;
import io.keikai.doc.api.impl.node.TextNode;
import io.keikai.doc.api.impl.node.style.ComponentStyle;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import org.zkoss.zhtml.Div;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;

public class ComponentNode
extends InlineNode<ComponentStyle> {
    public static final char PLACEHOLDER = '\ue000';
    static final String TYPE = "component";
    private final Component _component;
    private final Div _container = new Div();
    private boolean _inConstructor;

    public ComponentNode(Component component) {
        this(component, ComponentStyle.DEFAULT);
    }

    public ComponentNode(Component component, ComponentStyle style) {
        super(style);
        this._component = component;
        this._component.setParent((Component)this._container);
        this._inConstructor = true;
        this.addChild(new TextNode(""));
        this._inConstructor = false;
    }

    @Override
    String getType() {
        return TYPE;
    }

    @JsonIgnore
    public Component getComponent() {
        return this._component;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @JsonProperty(value="component")
    private byte[] componentAsByteArray() {
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            byte[] byArray;
            try (ObjectOutputStream oos = new ObjectOutputStream(bos);){
                oos.writeObject(this._component);
                byArray = bos.toByteArray();
            }
            return byArray;
        }
        catch (IOException e) {
            throw new UiException("Failed to serialize component: " + this._component, (Throwable)e);
        }
    }

    @JsonIgnore
    public Div getContainer() {
        return this._container;
    }

    @JsonProperty(value="containerUuid")
    private String getContainerUuid() {
        return this._container.getUuid();
    }

    @Override
    public void addChild(int index, TextNode child) {
        if (!this._inConstructor) {
            throw new UnsupportedOperationException("Cannot add child to ComponentNode");
        }
        super.addChild(index, child);
    }

    @Override
    public void removeChild(TextNode child) {
        throw new UnsupportedOperationException("Cannot remove child from ComponentNode");
    }

    @Override
    public void setStyle(ComponentStyle style) {
        ComponentStyle.TextWrap oriWrap = this.getStyle() == null ? null : ((ComponentStyle)this.getStyle()).getTextWrap();
        ComponentStyle.TextWrap newWrap = style.getTextWrap();
        if ((ComponentStyle.TextWrap.INLINE.equals((Object)oriWrap) || ComponentStyle.TextWrap.BREAK_TEXT.equals((Object)oriWrap)) && !ComponentStyle.TextWrap.INLINE.equals((Object)newWrap) && !ComponentStyle.TextWrap.BREAK_TEXT.equals((Object)newWrap)) {
            Runnable r = () -> {
                super.setStyle(style);
                int index = 0;
                while (((ParagraphNode)this.getParent()).getChild(index) instanceof ComponentNode) {
                    ++index;
                }
                ((ParagraphNode)this.getParent()).addChild(index, this);
            };
            DefaultDocumentModel model = this.getModel();
            if (model == null) {
                r.run();
            } else {
                model.runBatch(r);
            }
        } else {
            super.setStyle(style);
        }
    }

    @Override
    public <R> R accept(DocumentNodeVisitor<R> visitor) {
        return visitor.visit(this);
    }
}

