/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.doc.api.impl.node;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import io.keikai.doc.api.DocumentNode;
import io.keikai.doc.api.DocumentNodeStyle;
import io.keikai.doc.api.Path;
import io.keikai.doc.api.impl.model.DefaultDocumentModel;
import io.keikai.doc.api.impl.node.DefaultDocumentNodeFactory;
import io.keikai.doc.api.impl.node.DefaultDocumentRange;
import io.keikai.doc.api.impl.node.DocumentNodeVisitor;
import io.keikai.doc.api.impl.node.TextNode;
import io.keikai.doc.api.impl.operation.AddChildOperation;
import io.keikai.doc.api.impl.operation.MergeChildOperation;
import io.keikai.doc.api.impl.operation.RemoveChildOperation;
import io.keikai.doc.api.impl.operation.SetNodeOperation;
import io.keikai.doc.api.impl.operation.SetSelectionOperation;
import io.keikai.doc.api.impl.operation.SplitChildOperation;
import io.keikai.doc.api.impl.util.ObjectMapperUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.zkoss.json.JSONObject;

public abstract class AbstractDocumentNode<P extends AbstractDocumentNode<?, ?, ?>, C extends AbstractDocumentNode<?, ?, ?>, S extends DocumentNodeStyle>
implements DocumentNode<P, C, S> {
    private P _parent;
    private S _style;
    private final Map<Object, Object> _attributes = new HashMap<Object, Object>(2);
    private Map<Object, Object> _serverOnlyAttributes = new HashMap<Object, Object>(2);
    private List<C> _children = new ArrayList<C>();

    protected AbstractDocumentNode() {
    }

    protected AbstractDocumentNode(S style) {
        this.setStyle(style);
    }

    protected AbstractDocumentNode(Collection<C> children) {
        children.forEach(this::addChild);
    }

    protected AbstractDocumentNode(S style, Collection<C> children) {
        children.forEach(this::addChild);
        this.setStyle(style);
    }

    @JsonIgnore
    public DefaultDocumentModel getModel() {
        return this._parent == null ? null : ((AbstractDocumentNode)this._parent).getModel();
    }

    @Override
    @JsonIgnore
    public P getParent() {
        return this._parent;
    }

    public void setParent(AbstractDocumentNode<?, ?, ?> parent) {
        this._parent = parent;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="type")
    abstract String getType();

    @Override
    @JsonUnwrapped
    public S getStyle() {
        return this._style;
    }

    @Override
    public void setStyle(S style) {
        DefaultDocumentModel model = this.getModel();
        if (model == null) {
            this._style = style;
            return;
        }
        JSONObject oriMap = this._style == null ? Map.of() : ObjectMapperUtil.toJSON(this._style);
        JSONObject newMap = style == null ? Map.of() : ObjectMapperUtil.toJSON(style);
        HashSet intersection = new HashSet(oriMap.keySet());
        intersection.removeIf(arg_0 -> AbstractDocumentNode.lambda$setStyle$0((Map)oriMap, (Map)newMap, arg_0));
        intersection.forEach(oriMap.keySet()::remove);
        intersection.forEach(newMap.keySet()::remove);
        if (oriMap.isEmpty() && newMap.isEmpty()) {
            return;
        }
        this._style = style;
        model.fireOperation(new SetNodeOperation(model.getPath(this), this, (Map<Object, Object>)oriMap, (Map<Object, Object>)newMap));
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public Map<Object, Object> getAttributes() {
        return Collections.unmodifiableMap(this._attributes);
    }

    public void setAttributes(Map<Object, Object> attributes) {
        if (this._attributes.equals(attributes)) {
            return;
        }
        HashMap<Object, Object> oriAttributes = new HashMap<Object, Object>(this._attributes);
        this._attributes.clear();
        this._attributes.putAll(attributes);
        DefaultDocumentModel model = this.getModel();
        if (model != null) {
            model.fireOperation(new SetNodeOperation(model.getPath(this), this, Map.of("attributes", oriAttributes), Map.of("attributes", attributes)));
        }
    }

    public void addAttribute(Object key, Object value) {
        HashMap<Object, Object> newAttributes = new HashMap<Object, Object>(this._attributes);
        newAttributes.put(key, value);
        this.setAttributes(newAttributes);
    }

    public void removeAttribute(Object key) {
        HashMap<Object, Object> newAttributes = new HashMap<Object, Object>(this._attributes);
        newAttributes.remove(key);
        this.setAttributes(newAttributes);
    }

    public void setServerOnlyAttributes(Map<Object, Object> serverOnlyAttributes) {
        this._serverOnlyAttributes = serverOnlyAttributes;
    }

    public void addServerOnlyAttribute(Object key, Object value) {
        this._serverOnlyAttributes.put(key, value);
    }

    public void removeServerOnlyAttribute(Object key) {
        this._serverOnlyAttributes.remove(key);
    }

    @JsonIgnore
    public Map<Object, Object> getServerOnlyAttributes() {
        return Collections.unmodifiableMap(this._serverOnlyAttributes);
    }

    public Object getServerOnlyAttribute(Object key) {
        return this._serverOnlyAttributes.get(key);
    }

    @Override
    public List<C> getChildren() {
        return Collections.unmodifiableList(this._children);
    }

    @Override
    public C getChild(int index) {
        return (C)(index < 0 || index >= this.getChildCount() ? null : (AbstractDocumentNode)this.getChildren().get(index));
    }

    @Override
    @JsonIgnore
    public int getChildCount() {
        return this.getChildren().size();
    }

    @Override
    public int getChildIndex(C child) {
        return this.getChildren().indexOf(child);
    }

    @Override
    public void addChild(int index, C child) {
        DefaultDocumentModel model = this.getModel();
        Runnable r = () -> {
            DocumentNode oriParent = child.getParent();
            int newIndex = index;
            if (oriParent != null) {
                int oriIndex = ((AbstractDocumentNode)oriParent)._children.indexOf(child);
                if (oriParent == this && oriIndex < index) {
                    --newIndex;
                }
                ((AbstractDocumentNode)oriParent).removeChild((C)oriIndex);
            }
            child.setParent(this);
            this._children.add(newIndex, child);
            if (model != null) {
                model.fireOperation(new AddChildOperation(model.getPath((DocumentNode<?, ?, ?>)child), (DocumentNode<?, ?, ?>)child));
            }
        };
        if (model == null) {
            r.run();
        } else {
            model.runBatch(r);
        }
    }

    @Override
    public void removeChild(C child) {
        Path path = this.getModel().getPath((DocumentNode<?, ?, ?>)child);
        ((AbstractDocumentNode)child).setParent(null);
        this._children.remove(child);
        DefaultDocumentModel model = this.getModel();
        if (model != null) {
            model.fireOperation(new RemoveChildOperation(path, (DocumentNode<?, ?, ?>)child));
        }
    }

    public void splitChildToPreviousChild(int index, int position) {
        DocumentNode child = this.getChild(index);
        AbstractDocumentNode<P, C, S> prevChild = ((AbstractDocumentNode)child).split(position);
        this._children.add(index, prevChild);
        prevChild.setParent(this);
        DefaultDocumentModel model = this.getModel();
        if (model == null) {
            return;
        }
        model.runBatch(() -> AbstractDocumentNode.lambda$splitChildToPreviousChild$2((AbstractDocumentNode)child, model, prevChild, position));
    }

    public void mergeChildToPreviousChild(int index) {
        DocumentNode prevChild = this.getChild(index - 1);
        DocumentNode child = this.getChild(index);
        S style = ((AbstractDocumentNode)child).getStyle();
        this._children.remove(child);
        int position = ((AbstractDocumentNode)prevChild).merge((AbstractDocumentNode<?, ?, ?>)child);
        DefaultDocumentModel model = this.getModel();
        if (model == null) {
            return;
        }
        model.runBatch(() -> AbstractDocumentNode.lambda$mergeChildToPreviousChild$3(model, (AbstractDocumentNode)prevChild, position, style, (AbstractDocumentNode)child));
    }

    AbstractDocumentNode<P, C, S> split(int position) {
        JSONObject map = ObjectMapperUtil.toJSON(this);
        map.remove("children");
        AbstractDocumentNode<?, ?, ?> prev = DefaultDocumentNodeFactory.create(map);
        prev._children = new ArrayList<C>(this._children.subList(0, position));
        prev._children.forEach(child -> child.setParent(prev));
        this._children = new ArrayList<C>(this._children.subList(position, this._children.size()));
        return prev;
    }

    int merge(AbstractDocumentNode<?, ?, ?> node) {
        this._children.addAll(node._children);
        int position = node.getChildCount();
        node._children.forEach(child -> child.setParent(this));
        node._children.clear();
        return position;
    }

    public <R> List<R> visitChildren(DocumentNodeVisitor<R> visitor) {
        ArrayList<R> rs = new ArrayList<R>();
        for (int i = 0; i < this.getChildCount(); ++i) {
            DocumentNode child = this.getChild(i);
            if (child == null) continue;
            rs.add(child.accept(visitor));
        }
        return rs;
    }

    private static /* synthetic */ void lambda$mergeChildToPreviousChild$3(DefaultDocumentModel model, AbstractDocumentNode prevChild, int position, DocumentNodeStyle style, AbstractDocumentNode child) {
        Path mergePath = model.getPath(prevChild).getNextSibling();
        model.fireOperation(new MergeChildOperation(mergePath, position, (Map<Object, Object>)(style == null ? Collections.emptyMap() : ObjectMapperUtil.toJSON(style))));
        DefaultDocumentRange selection = model.getSelection();
        if (selection == null) {
            return;
        }
        TextNode startNode = selection.getStartNode();
        TextNode endNode = selection.getEndNode();
        if (child == startNode || child == endNode) {
            if (child == startNode) {
                selection.setStart((TextNode)prevChild, position + selection.getStartOffset());
            }
            if (child == endNode) {
                selection.setEnd((TextNode)prevChild, position + selection.getEndOffset());
            }
            model.fireOperation(new SetSelectionOperation(model.getPath(selection.getStartNode()), selection.getStartOffset(), model.getPath(selection.getEndNode()), selection.getEndOffset()));
        }
    }

    private static /* synthetic */ void lambda$splitChildToPreviousChild$2(AbstractDocumentNode child, DefaultDocumentModel model, AbstractDocumentNode prevChild, int position) {
        JSONObject properties = ObjectMapperUtil.toJSON(child);
        properties.remove("children");
        model.fireOperation(new SplitChildOperation(model.getPath(prevChild), position, (Map<Object, Object>)properties));
        DefaultDocumentRange selection = model.getSelection();
        if (selection == null) {
            return;
        }
        TextNode startNode = selection.getStartNode();
        TextNode endNode = selection.getEndNode();
        if (child == startNode || child == endNode) {
            if (child == startNode) {
                int startOffset = selection.getStartOffset();
                if (startOffset < position) {
                    selection.setStart((TextNode)prevChild, startOffset);
                } else {
                    selection.setStart((TextNode)child, startOffset - position);
                }
            }
            if (child == endNode) {
                int endOffset = selection.getEndOffset();
                if (endOffset <= position) {
                    selection.setEnd((TextNode)prevChild, endOffset);
                } else {
                    selection.setEnd((TextNode)child, endOffset - position);
                }
            }
            model.fireOperation(new SetSelectionOperation(model.getPath(selection.getStartNode()), selection.getStartOffset(), model.getPath(selection.getEndNode()), selection.getEndOffset()));
        }
    }

    private static /* synthetic */ boolean lambda$setStyle$0(Map oriMap, Map newMap, Object key) {
        return !Objects.equals(oriMap.get(key), newMap.get(key));
    }
}

