/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.doc.api.editor;

import io.keikai.doc.api.DocumentNode;
import io.keikai.doc.api.Path;
import io.keikai.doc.api.editor.ComponentView;
import io.keikai.doc.api.editor.ParagraphView;
import io.keikai.doc.api.editor.TableView;
import io.keikai.doc.api.impl.model.DefaultDocumentModel;
import io.keikai.doc.api.impl.node.AbstractDocumentNode;
import io.keikai.doc.api.impl.node.ComponentNode;
import io.keikai.doc.api.impl.node.DocumentNodeLazyIterator;
import io.keikai.doc.api.impl.node.ParagraphNode;
import io.keikai.doc.api.impl.node.TableNode;
import java.util.stream.Stream;

public class View<N extends AbstractDocumentNode<?, ?, ?>> {
    private final N _node;

    protected View(N node) {
        this._node = node;
    }

    public N getNode() {
        return this._node;
    }

    public Path getPath() {
        DefaultDocumentModel model = ((AbstractDocumentNode)this._node).getModel();
        return model == null ? null : model.getPath((DocumentNode<?, ?, ?>)this._node);
    }

    public Stream<ParagraphView> getParagraphs() {
        return new DocumentNodeLazyIterator((DocumentNode<?, ?, ?>)this._node).stream().skip(1L).filter(ParagraphNode.class::isInstance).map(ParagraphNode.class::cast).map(ParagraphView::new);
    }

    public Stream<ParagraphView> getDirectParagraphs() {
        return ((AbstractDocumentNode)this._node).getChildren().stream().filter(ParagraphNode.class::isInstance).map(ParagraphNode.class::cast).map(ParagraphView::new);
    }

    public Stream<ComponentView> getComponents() {
        return new DocumentNodeLazyIterator((DocumentNode<?, ?, ?>)this._node).stream().skip(1L).filter(ComponentNode.class::isInstance).map(ComponentNode.class::cast).map(ComponentView::new);
    }

    public Stream<ComponentView> getDirectComponents() {
        return ((AbstractDocumentNode)this._node).getChildren().stream().filter(ComponentNode.class::isInstance).map(ComponentNode.class::cast).map(ComponentView::new);
    }

    public Stream<TableView> getTables() {
        return new DocumentNodeLazyIterator((DocumentNode<?, ?, ?>)this._node).stream().skip(1L).filter(TableNode.class::isInstance).map(TableNode.class::cast).map(TableView::new);
    }

    public Stream<TableView> getDirectTables() {
        return ((AbstractDocumentNode)this._node).getChildren().stream().filter(TableNode.class::isInstance).map(TableNode.class::cast).map(TableView::new);
    }
}

