/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.doc.api.editor;

import io.keikai.doc.api.editor.BlockView;
import io.keikai.doc.api.editor.TableCellView;
import io.keikai.doc.api.impl.node.TableCellNode;
import io.keikai.doc.api.impl.node.TableNode;
import io.keikai.doc.api.impl.node.TableRowNode;
import io.keikai.doc.api.impl.node.style.TableCellStyle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class TableView
extends BlockView<TableNode> {
    protected TableView(TableNode node) {
        super(node);
    }

    public int getColCount() {
        TableRowNode row = (TableRowNode)((TableNode)this.getNode()).getChild(0);
        return row == null ? 0 : row.getChildren().stream().mapToInt(cell -> ((TableCellStyle)cell.getStyle()).getColSpan()).sum();
    }

    public int getRowCount() {
        return ((TableNode)this.getNode()).getChildCount();
    }

    public List<List<TableCellView>> getCells() {
        int rowCount = this.getRowCount();
        int colCount = this.getColCount();
        TableCellView[][] cells = new TableCellView[rowCount][colCount];
        for (int r = 0; r < rowCount; ++r) {
            TableRowNode rowNode = (TableRowNode)((TableNode)this.getNode()).getChild(r);
            Iterator cellIterator = rowNode.getChildren().iterator();
            for (int c = 0; c < colCount; ++c) {
                if (cells[r][c] != null) continue;
                TableCellNode cellNode = (TableCellNode)cellIterator.next();
                TableCellView merger = new TableCellView(r, c, null, cellNode);
                for (int dr = 0; dr < ((TableCellStyle)cellNode.getStyle()).getRowSpan(); ++dr) {
                    for (int dc = 0; dc < ((TableCellStyle)cellNode.getStyle()).getColSpan(); ++dc) {
                        int nr = r + dr;
                        int nc = c + dc;
                        cells[nr][nc] = dr == 0 && dc == 0 ? merger : new TableCellView(nr, nc, merger, cellNode);
                    }
                }
            }
        }
        return Arrays.stream(cells).map(Arrays::asList).collect(Collectors.toList());
    }

    public List<List<TableCellView>> getCells(int tRow, int lCol, int bRow, int rCol) {
        List<List<TableCellView>> cells = this.getCells();
        ArrayList<List<TableCellView>> subCells = new ArrayList<List<TableCellView>>();
        for (int r = tRow; r <= bRow; ++r) {
            subCells.add(cells.get(r).subList(lCol, rCol + 1));
        }
        return subCells;
    }

    public List<TableCellView> getZFlattenedCells() {
        return this.getCells().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    public List<TableCellView> getZFlattenedCells(int tRow, int lCol, int bRow, int rCol) {
        return this.getCells(tRow, lCol, bRow, rCol).stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    public List<TableCellView> getNFlattenedCells() {
        ArrayList<TableCellView> flattened = new ArrayList<TableCellView>();
        List<List<TableCellView>> cells = this.getCells();
        int colCount = cells.get(0).size();
        for (int c = 0; c < colCount; ++c) {
            for (List<TableCellView> row : cells) {
                flattened.add(row.get(c));
            }
        }
        return flattened;
    }

    public List<TableCellView> getNFlattenedCells(int tRow, int lCol, int bRow, int rCol) {
        ArrayList<TableCellView> flattened = new ArrayList<TableCellView>();
        List<List<TableCellView>> cells = this.getCells(tRow, lCol, bRow, rCol);
        int colCount = cells.get(0).size();
        for (int c = 0; c < colCount; ++c) {
            for (List<TableCellView> row : cells) {
                flattened.add(row.get(c));
            }
        }
        return flattened;
    }

    public TableCellView getCell(int row, int col) {
        List<List<TableCellView>> cells = this.getCells();
        return row < 0 || row >= cells.size() || col < 0 || col >= cells.get(0).size() ? null : cells.get(row).get(col);
    }
}

