/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.doc.api.editor;

import io.keikai.doc.api.DocumentModel;
import io.keikai.doc.api.Point;
import io.keikai.doc.api.editor.BlockCommand;
import io.keikai.doc.api.editor.Command;
import io.keikai.doc.api.editor.ParagraphView;
import io.keikai.doc.api.editor.TableCellView;
import io.keikai.doc.api.editor.TableView;
import io.keikai.doc.api.editor.View;
import io.keikai.doc.api.impl.model.DefaultDocumentModel;
import io.keikai.doc.api.impl.node.BlockNode;
import io.keikai.doc.api.impl.node.ParagraphNode;
import io.keikai.doc.api.impl.node.TableCellNode;
import io.keikai.doc.api.impl.node.TableNode;
import io.keikai.doc.api.impl.node.TableRowNode;
import io.keikai.doc.api.impl.node.style.TableCellStyle;
import io.keikai.doc.api.impl.node.style.TableRowStyle;
import io.keikai.doc.api.impl.node.style.TableStyle;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.zkoss.zk.ui.UiException;

public class TableCommand
extends BlockCommand<TableNode> {
    protected TableCommand(BiFunction<DocumentModel, Point, List<TableNode>> finder) {
        super(finder);
    }

    protected TableCommand(boolean atSelection, BiFunction<DocumentModel, Point, List<TableNode>> finder) {
        super(atSelection, finder);
    }

    protected TableCommand(Command<TableNode> command) {
        super(command);
    }

    private TableCommand withAction(Consumer<TableNode> consumer) {
        TableCommand command = new TableCommand(this);
        command.addAction(consumer);
        return command;
    }

    public TableCommand cell(int row, int col, BlockCommand<?> command) {
        return this.withAction(table -> {
            TableCellView cellView = new TableView((TableNode)table).getCell(row, col);
            if (cellView == null) {
                throw new NoSuchElementException("No cell found at row " + row + " column " + col);
            }
            DefaultDocumentModel model = table.getModel();
            List nodes = command.execute(model, null);
            nodes.forEach(block -> ((TableCellNode)cellView.getNode()).addChild(block));
        });
    }

    public TableCommand merge(int tRow, int lCol, int bRow, int rCol) {
        return this.withAction(table -> {
            List<TableCellView> cellViews = new TableView((TableNode)table).getZFlattenedCells(tRow, lCol, bRow, rCol);
            if (cellViews.get(0) == null) {
                throw new UiException("No cell found at row " + tRow + " column " + lCol);
            }
            TableCellNode topLeftCell = (TableCellNode)cellViews.get(0).getNode();
            cellViews.stream().skip(1L).forEach(cellView -> {
                TableCellNode cell;
                block6: {
                    block5: {
                        if (cellView == null || cellView.getMerger() != null) {
                            return;
                        }
                        cell = (TableCellNode)cellView.getNode();
                        if (cell.getChildCount() != 1) break block5;
                        if (Optional.of((BlockNode)cell.getChild(0)).filter(ParagraphNode.class::isInstance).map(p -> new ParagraphView((ParagraphNode)p).getText().isEmpty()).orElse(false).booleanValue()) break block6;
                    }
                    for (int i = 0; i < cell.getChildCount(); ++i) {
                        topLeftCell.addChild((BlockNode)cell.getChild(i));
                    }
                }
                ((TableRowNode)cell.getParent()).removeChild(cell);
            });
            topLeftCell.setStyle(((TableCellStyle)topLeftCell.getStyle()).withRowSpan(bRow - tRow + 1).withColSpan(rCol - lCol + 1));
        });
    }

    public TableCommand unmerge(int tRow, int lCol, int bRow, int rCol) {
        return this.withAction(table -> {
            List<List<TableCellView>> views = new TableView((TableNode)table).getCells();
            List mergerViews = views.stream().flatMap(Collection::stream).filter(cell -> cell != null && cell.getMerger() == null).collect(Collectors.toList());
            Collections.reverse(mergerViews);
            for (TableCellView mergerView : mergerViews) {
                int mr = mergerView.getRow();
                int mc = mergerView.getCol();
                TableCellNode merger = (TableCellNode)mergerView.getNode();
                int rowSpan = ((TableCellStyle)merger.getStyle()).getRowSpan();
                int colSpan = ((TableCellStyle)merger.getStyle()).getColSpan();
                merger.setStyle(((TableCellStyle)merger.getStyle()).withRowSpan(1).withColSpan(1));
                TableCellStyle style = (TableCellStyle)merger.getStyle();
                for (int r = mr; r < mr + rowSpan; ++r) {
                    TableCellNode prevCellNode = r == mr ? merger : null;
                    for (int c = mc - 1; prevCellNode == null && c >= 0; --c) {
                        TableCellView view = views.get(r).get(c);
                        if (view == null || view.getMerger() != null) continue;
                        prevCellNode = (TableCellNode)view.getNode();
                    }
                    TableRowNode rowNode = (TableRowNode)table.getChild(r);
                    for (int c = mc; c < mc + colSpan; ++c) {
                        if (r == mr && c == mc) continue;
                        TableCellNode newCellNode = new TableCellNode(style, (Collection<BlockNode<?, ?>>)List.of(new ParagraphNode("")));
                        rowNode.addChild(prevCellNode == null ? 0 : rowNode.getChildIndex(prevCellNode) + 1, newCellNode);
                    }
                }
            }
        });
    }

    public TableCommand style(UnaryOperator<TableStyle> mapper) {
        return this.withAction(table -> table.setStyle((TableStyle)mapper.apply((TableStyle)table.getStyle())));
    }

    public TableCommand style(int tRow, int bRow, UnaryOperator<TableRowStyle> mapper) {
        return this.withAction(table -> {
            for (int row = tRow; row <= Math.min(bRow, table.getChildCount() - 1); ++row) {
                TableRowNode rowNode = (TableRowNode)table.getChild(row);
                rowNode.setStyle((TableRowStyle)mapper.apply((TableRowStyle)rowNode.getStyle()));
            }
        });
    }

    public TableCommand style(int tRow, int lCol, int bRow, int rCol, UnaryOperator<TableCellStyle> mapper) {
        return this.withAction(table -> new TableView((TableNode)table).getZFlattenedCells(tRow, lCol, bRow, rCol).stream().filter(Objects::nonNull).map(View::getNode).forEach(cell -> cell.setStyle((TableCellStyle)mapper.apply((TableCellStyle)cell.getStyle()))));
    }

    public TableCommand attr(Object key, Object value) {
        return this.withAction(table -> table.addAttribute(key, value));
    }

    public TableCommand removeAttr(Object key) {
        return this.withAction(table -> table.removeAttribute(key));
    }
}

