/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.doc.api.editor;

import io.keikai.doc.api.DocumentNode;
import io.keikai.doc.api.editor.ParagraphView;
import io.keikai.doc.api.editor.View;
import io.keikai.doc.api.impl.node.AbstractDocumentNode;
import io.keikai.doc.api.impl.node.ComponentNode;
import io.keikai.doc.api.impl.node.DefaultDocumentRange;
import io.keikai.doc.api.impl.node.InlineNode;
import io.keikai.doc.api.impl.node.ParagraphNode;
import io.keikai.doc.api.impl.node.TextNode;
import io.keikai.doc.api.impl.node.style.ParagraphStyle;
import io.keikai.doc.api.impl.node.style.TextStyle;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import org.zkoss.zk.ui.UiException;

public class SelectionView
extends View<AbstractDocumentNode<?, ?, ?>> {
    private final DefaultDocumentRange _range;

    protected SelectionView(DefaultDocumentRange range) {
        super(null);
        this._range = range;
    }

    public ParagraphView getStartParagraph() {
        return new ParagraphView(this.getParagraph(false));
    }

    public int getStartOffset() {
        return this.getOffset(false) + this._range.getStartOffset();
    }

    public ParagraphView getEndParagraph() {
        return new ParagraphView(this.getParagraph(true));
    }

    public int getEndOffset() {
        return this.getOffset(true) + this._range.getEndOffset();
    }

    private ParagraphNode getParagraph(boolean isEndNode) {
        DocumentNode<ParagraphNode, TextNode, TextStyle> node;
        TextNode textNode = node = isEndNode ? this._range.getEndNode() : this._range.getStartNode();
        if (!(node.getParent() instanceof ParagraphNode)) {
            node = node.getParent();
        }
        return (ParagraphNode)node.getParent();
    }

    private int getOffset(boolean isEndNode) {
        ParagraphNode paragraph = this.getParagraph(isEndNode);
        TextNode node = isEndNode ? this._range.getEndNode() : this._range.getStartNode();
        int offset = 0;
        for (int i = 0; i < paragraph.getChildCount(); ++i) {
            InlineNode child = (InlineNode)paragraph.getChild(i);
            if (child instanceof TextNode) {
                if (child == node) break;
                offset += ((TextNode)child).getText().length();
                continue;
            }
            if (child instanceof ComponentNode) {
                if (child.getChild(0) == node) {
                    if (!isEndNode) break;
                    ++offset;
                    break;
                }
                ++offset;
                continue;
            }
            throw new UiException("Unsupported node type: " + child.getClass());
        }
        return offset;
    }

    public boolean allTextStylesMatched(Predicate<TextStyle> predicate) {
        return this._range.getNodes().filter(TextNode.class::isInstance).map(TextNode.class::cast).allMatch(node -> predicate.test((TextStyle)node.getStyle()));
    }

    public <T> boolean allTextStylesMatched(Function<TextStyle, T> function) {
        return this._range.getNodes().filter(TextNode.class::isInstance).map(TextNode.class::cast).map(node -> function.apply((TextStyle)node.getStyle())).distinct().count() == 1L;
    }

    public <T> T getStartTextNodeStyle(Function<TextStyle, T> function) {
        return Optional.ofNullable((TextStyle)this._range.getStartNode().getStyle()).map(function).orElse(null);
    }

    public <T> boolean allParagraphStyleMatched(Function<ParagraphStyle, T> function) {
        return this._range.getNodes().filter(ParagraphNode.class::isInstance).map(ParagraphNode.class::cast).map(node -> function.apply((ParagraphStyle)node.getStyle())).distinct().count() == 1L;
    }

    public <T> T getStartParagraphStyle(Function<ParagraphStyle, T> function) {
        DocumentNode<ParagraphNode, TextNode, TextStyle> parent = this._range.getStartNode();
        while (!(parent instanceof ParagraphNode)) {
            parent = parent.getParent();
        }
        return Optional.ofNullable((ParagraphStyle)((ParagraphNode)parent).getStyle()).map(function).orElse(null);
    }

    public boolean isRange() {
        return this._range.getStartNode() != this._range.getEndNode() || this._range.getStartOffset() != this._range.getEndOffset();
    }
}

