/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.doc.api.editor;

import io.keikai.doc.api.DocumentModel;
import io.keikai.doc.api.DocumentNode;
import io.keikai.doc.api.DocumentRange;
import io.keikai.doc.api.DocumentSelectableModel;
import io.keikai.doc.api.Point;
import io.keikai.doc.api.editor.Command;
import io.keikai.doc.api.impl.node.AbstractDocumentNode;
import io.keikai.doc.api.impl.node.DefaultDocumentRange;
import io.keikai.doc.api.impl.node.ParagraphNode;
import io.keikai.doc.api.impl.node.TableCellNode;
import io.keikai.doc.api.impl.node.TableNode;
import io.keikai.doc.api.impl.node.TableRowNode;
import io.keikai.doc.api.impl.node.TextNode;
import io.keikai.doc.api.impl.node.style.ParagraphStyle;
import io.keikai.doc.api.impl.node.style.TableCellStyle;
import io.keikai.doc.api.impl.node.style.TableRowStyle;
import io.keikai.doc.api.impl.node.style.TableStyle;
import io.keikai.doc.api.impl.node.style.TextStyle;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import org.zkoss.zk.ui.UiException;

public class SelectionCommand
extends Command<AbstractDocumentNode<?, ?, ?>> {
    private final List<Consumer<DocumentSelectableModel>> _actions = new ArrayList<Consumer<DocumentSelectableModel>>();

    protected SelectionCommand() {
        super((DocumentModel model, Point point) -> null);
    }

    protected SelectionCommand(SelectionCommand command) {
        super(command);
        this._actions.addAll(command._actions);
    }

    private SelectionCommand withAction(Consumer<DocumentSelectableModel> action) {
        SelectionCommand command = new SelectionCommand(this);
        command._actions.add(action);
        return command;
    }

    public SelectionCommand collapseToStart() {
        return this.withAction(model -> {
            DocumentRange selection = model.getSelection();
            if (!(selection.getStartNode() instanceof TextNode)) {
                throw new UiException("The start node must be a text node to collapse to start");
            }
            TextNode startNode = (TextNode)selection.getStartNode();
            int startOffset = selection.getStartOffset();
            model.setSelection(new DefaultDocumentRange(startNode, startOffset, startNode, startOffset));
        });
    }

    public SelectionCommand collapseToEnd() {
        return this.withAction(model -> {
            DocumentRange selection = model.getSelection();
            if (!(selection.getEndNode() instanceof TextNode)) {
                throw new UiException("The end node must be a text node to collapse to end");
            }
            TextNode endNode = (TextNode)selection.getEndNode();
            int endOffset = selection.getEndOffset();
            model.setSelection(new DefaultDocumentRange(endNode, endOffset, endNode, endOffset));
        });
    }

    public SelectionCommand paragraphStyle(UnaryOperator<ParagraphStyle> mapper) {
        return this.withAction(model -> {
            DocumentRange selection = model.getSelection();
            if (selection instanceof DefaultDocumentRange) {
                ((DefaultDocumentRange)selection).getNodes().filter(ParagraphNode.class::isInstance).map(ParagraphNode.class::cast).forEach(p -> p.setStyle((ParagraphStyle)mapper.apply((ParagraphStyle)p.getStyle())));
            }
        });
    }

    public SelectionCommand textStyle(UnaryOperator<TextStyle> mapper) {
        return this.withAction(model -> {
            DocumentRange selection = model.getSelection();
            if (selection instanceof DefaultDocumentRange) {
                DocumentNode<?, ?, ?> startNode = selection.getStartNode();
                DocumentNode<?, ?, ?> endNode = selection.getEndNode();
                int startOffset = selection.getStartOffset();
                int endOffset = selection.getEndOffset();
                ((DefaultDocumentRange)selection).getNodes().filter(TextNode.class::isInstance).map(TextNode.class::cast).forEach(node -> node.setStyle(node == startNode ? startOffset : 0, node == endNode ? endOffset : node.getText().length(), (TextStyle)mapper.apply((TextStyle)node.getStyle())));
            }
        });
    }

    public SelectionCommand tableStyle(UnaryOperator<TableStyle> mapper) {
        return this.withAction(model -> {
            DocumentRange selection = model.getSelection();
            if (selection instanceof DefaultDocumentRange) {
                ((DefaultDocumentRange)selection).getNodes().filter(TableNode.class::isInstance).map(TableNode.class::cast).forEach(t -> t.setStyle((TableStyle)mapper.apply((TableStyle)t.getStyle())));
            }
        });
    }

    public SelectionCommand tableRowStyle(UnaryOperator<TableRowStyle> mapper) {
        return this.withAction(model -> {
            DocumentRange selection = model.getSelection();
            if (selection instanceof DefaultDocumentRange) {
                ((DefaultDocumentRange)selection).getNodes().filter(TableRowNode.class::isInstance).map(TableRowNode.class::cast).forEach(r -> r.setStyle((TableRowStyle)mapper.apply((TableRowStyle)r.getStyle())));
            }
        });
    }

    public SelectionCommand tableCellStyle(UnaryOperator<TableCellStyle> mapper) {
        return this.withAction(model -> {
            DocumentRange selection = model.getSelection();
            if (selection instanceof DefaultDocumentRange) {
                ((DefaultDocumentRange)selection).getNodes().filter(TableCellNode.class::isInstance).map(TableCellNode.class::cast).forEach(c -> c.setStyle((TableCellStyle)mapper.apply((TableCellStyle)c.getStyle())));
            }
        });
    }

    @Override
    protected List<AbstractDocumentNode<?, ?, ?>> execute(DocumentModel model, Point point) {
        if (model instanceof DocumentSelectableModel) {
            this._actions.forEach(action -> action.accept((DocumentSelectableModel)((Object)model)));
            return List.of();
        }
        throw new UiException("The model must implement DocumentSelectableModel");
    }
}

