/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.doc.api.editor;

import io.keikai.doc.api.DocumentModel;
import io.keikai.doc.api.Point;
import io.keikai.doc.api.editor.BlockCommand;
import io.keikai.doc.api.editor.Command;
import io.keikai.doc.api.editor.ParagraphView;
import io.keikai.doc.api.impl.node.ComponentNode;
import io.keikai.doc.api.impl.node.DocumentNodeVisitor;
import io.keikai.doc.api.impl.node.InlineNode;
import io.keikai.doc.api.impl.node.PageNumberNode;
import io.keikai.doc.api.impl.node.ParagraphNode;
import io.keikai.doc.api.impl.node.TextNode;
import io.keikai.doc.api.impl.node.style.ComponentStyle;
import io.keikai.doc.api.impl.node.style.ParagraphStyle;
import io.keikai.doc.api.impl.node.style.TextStyle;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import java.util.function.UnaryOperator;
import org.zkoss.util.Pair;
import org.zkoss.zk.ui.Component;

public class ParagraphCommand
extends BlockCommand<ParagraphNode> {
    protected ParagraphCommand(BiFunction<DocumentModel, Point, List<ParagraphNode>> finder) {
        super(finder);
    }

    protected ParagraphCommand(boolean atSelection, BiFunction<DocumentModel, Point, List<ParagraphNode>> finder) {
        super(atSelection, finder);
    }

    protected ParagraphCommand(Command<ParagraphNode> command) {
        super(command);
    }

    private ParagraphCommand withAction(Consumer<ParagraphNode> consumer) {
        ParagraphCommand command = new ParagraphCommand(this);
        command.addAction(consumer);
        return command;
    }

    public ParagraphCommand text(String text) {
        return this.withAction(paragraph -> {
            InlineNode lastNode = (InlineNode)paragraph.getChild(paragraph.getChildCount() - 1);
            if (lastNode instanceof TextNode) {
                TextNode lastTextNode = (TextNode)lastNode;
                lastTextNode.addText(lastTextNode.getText().length(), text);
            } else {
                paragraph.addChild(new TextNode(text));
            }
        });
    }

    public ParagraphCommand text(ToIntFunction<String> offset, String text) {
        return this.withAction(paragraph -> {
            StringBuilder builder = new StringBuilder();
            int startOffset = offset.applyAsInt(new ParagraphView((ParagraphNode)paragraph).getText());
            for (int i = 0; i < paragraph.getChildCount(); ++i) {
                InlineNode child = (InlineNode)paragraph.getChild(i);
                if (child instanceof TextNode) {
                    TextNode node = (TextNode)child;
                    int nodeStart = builder.length();
                    int nodeEnd = builder.append(node.getText()).length();
                    if (nodeStart > startOffset || startOffset > nodeEnd) continue;
                    node.addText(startOffset - nodeStart, text);
                    break;
                }
                if (!(child instanceof ComponentNode)) continue;
                builder.append('\ue000');
            }
        });
    }

    public ParagraphCommand removeText(Function<String, Pair<Integer, Integer>> offsets) {
        return this.withAction(paragraph -> {
            StringBuilder builder = new StringBuilder();
            Pair pair = (Pair)offsets.apply(new ParagraphView((ParagraphNode)paragraph).getText());
            for (int i = 0; i < paragraph.getChildCount(); ++i) {
                InlineNode child = (InlineNode)paragraph.getChild(i);
                int nodeStart = builder.length();
                if (child instanceof TextNode) {
                    TextNode node = (TextNode)child;
                    int nodeEnd = builder.append(node.getText()).length();
                    if ((Integer)pair.x <= nodeStart && nodeEnd <= (Integer)pair.y) {
                        paragraph.removeChild(node);
                        continue;
                    }
                    if ((Integer)pair.x <= nodeStart && nodeStart < (Integer)pair.y) {
                        node.removeText(0, (Integer)pair.y - nodeStart);
                        continue;
                    }
                    if ((Integer)pair.x < nodeEnd && nodeEnd <= (Integer)pair.y) {
                        node.removeText((Integer)pair.x - nodeStart, nodeEnd - nodeStart);
                        continue;
                    }
                    if ((Integer)pair.y > nodeStart) continue;
                    break;
                }
                if (!(child instanceof ComponentNode)) continue;
                int nodeEnd = builder.append('\ue000').length();
                if ((Integer)pair.x > nodeStart || nodeEnd > (Integer)pair.y) continue;
                paragraph.removeChild(child);
            }
            if (paragraph.getChildCount() == 0) {
                paragraph.addChild(new TextNode(""));
            }
        });
    }

    public ParagraphCommand component(Component component) {
        return this.component(component, UnaryOperator.identity());
    }

    public ParagraphCommand component(Component component, UnaryOperator<ComponentStyle> mapper) {
        return this.withAction(paragraph -> {
            ComponentStyle style = (ComponentStyle)mapper.apply(ComponentStyle.DEFAULT);
            ComponentStyle.TextWrap wrap = style.getTextWrap();
            ComponentNode componentNode = new ComponentNode(component, style);
            if (ComponentStyle.TextWrap.INLINE.equals((Object)wrap) || ComponentStyle.TextWrap.BREAK_TEXT.equals((Object)wrap)) {
                paragraph.addChild(componentNode);
                paragraph.addChild(new TextNode(""));
            } else {
                paragraph.addChild(0, componentNode);
            }
        });
    }

    public ParagraphCommand component(ToIntFunction<String> offset, Component component) {
        return this.component(offset, component, UnaryOperator.identity());
    }

    public ParagraphCommand component(ToIntFunction<String> offset, Component component, UnaryOperator<ComponentStyle> mapper) {
        ComponentStyle style = (ComponentStyle)mapper.apply(ComponentStyle.DEFAULT);
        ComponentStyle.TextWrap wrap = style.getTextWrap();
        if (ComponentStyle.TextWrap.INLINE.equals((Object)wrap) || ComponentStyle.TextWrap.BREAK_TEXT.equals((Object)wrap)) {
            return this.withAction(paragraph -> {
                StringBuilder builder = new StringBuilder();
                int startOffset = offset.applyAsInt(new ParagraphView((ParagraphNode)paragraph).getText());
                for (int i = 0; i < paragraph.getChildCount(); ++i) {
                    InlineNode child = (InlineNode)paragraph.getChild(i);
                    if (child instanceof TextNode) {
                        TextNode node = (TextNode)child;
                        int nodeStart = builder.length();
                        int nodeEnd = builder.append(node.getText()).length();
                        if (nodeStart > startOffset || startOffset > nodeEnd) continue;
                        paragraph.splitChildToPreviousChild(i, startOffset - nodeStart);
                        paragraph.addChild(i + 1, new ComponentNode(component, style));
                        break;
                    }
                    if (!(child instanceof ComponentNode)) continue;
                    builder.append('\ue000');
                }
            });
        }
        return this.component(component, mapper);
    }

    public ParagraphCommand pageNumber() {
        return this.withAction(paragraph -> {
            paragraph.addChild(new PageNumberNode());
            paragraph.addChild(new TextNode(""));
        });
    }

    public ParagraphCommand style(UnaryOperator<ParagraphStyle> mapper) {
        return this.withAction(paragraph -> paragraph.setStyle((ParagraphStyle)mapper.apply((ParagraphStyle)paragraph.getStyle())));
    }

    public ParagraphCommand style(final int startOffset, final int endOffset, UnaryOperator<TextStyle> mapper) {
        return this.withAction(paragraph -> {
            final ArrayList texts = new ArrayList();
            final ArrayList runnables = new ArrayList();
            paragraph.accept(new DocumentNodeVisitor<Void>(){
                private final StringBuilder _builder = new StringBuilder();

                @Override
                public Void visit(TextNode node) {
                    int nodeStart = this._builder.length();
                    int nodeEnd = this._builder.append(node.getText()).length();
                    if (nodeStart <= startOffset && endOffset <= nodeEnd || startOffset <= nodeStart && nodeStart < endOffset || startOffset < nodeEnd && nodeEnd <= endOffset) {
                        int index;
                        ParagraphNode parent;
                        int runnableCount = runnables.size();
                        if (endOffset < nodeEnd) {
                            parent = (ParagraphNode)node.getParent();
                            index = parent.getChildIndex(node);
                            runnables.add(() -> {
                                parent.splitChildToPreviousChild(index, endOffset - nodeStart);
                                texts.add((TextNode)parent.getChild(index));
                            });
                        }
                        if (nodeStart < startOffset) {
                            parent = (ParagraphNode)node.getParent();
                            index = parent.getChildIndex(node);
                            runnables.add(() -> {
                                parent.splitChildToPreviousChild(index, startOffset - nodeStart);
                                texts.add((TextNode)parent.getChild(index + 1));
                            });
                        }
                        if (runnables.size() == runnableCount) {
                            texts.add(node);
                        }
                    }
                    return (Void)DocumentNodeVisitor.super.visit(node);
                }
            });
            runnables.forEach(Runnable::run);
            texts.forEach(text -> text.setStyle((TextStyle)mapper.apply((TextStyle)text.getStyle())));
        });
    }

    public ParagraphCommand attr(Object key, Object value) {
        return this.withAction(paragraph -> paragraph.addAttribute(key, value));
    }

    public ParagraphCommand removeAttr(Object key) {
        return this.withAction(paragraph -> paragraph.removeAttribute(key));
    }
}

