/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.doc.api.editor;

import io.keikai.doc.api.DocumentModel;
import io.keikai.doc.api.Point;
import io.keikai.doc.api.impl.node.AbstractDocumentNode;
import io.keikai.doc.api.impl.node.DefaultDocumentNodeFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class Command<N extends AbstractDocumentNode<?, ?, ?>> {
    private final boolean _atSelection;
    private final boolean _shouldClone;
    private final BiFunction<DocumentModel, Point, List<N>> _finder;
    private final List<Consumer<N>> _actions = new ArrayList<Consumer<N>>();

    protected Command(BiFunction<DocumentModel, Point, List<N>> finder) {
        this(false, finder);
    }

    protected Command(boolean atSelection, BiFunction<DocumentModel, Point, List<N>> finder) {
        this._atSelection = atSelection;
        this._shouldClone = false;
        this._finder = finder;
    }

    protected boolean isAtSelection() {
        return this._atSelection;
    }

    protected Command(Command<N> command) {
        this(false, command);
    }

    protected Command(boolean shouldClone, Command<N> command) {
        this._shouldClone = shouldClone;
        this._atSelection = command._atSelection;
        this._finder = command._finder;
        this._actions.addAll(command._actions);
    }

    protected List<N> execute(DocumentModel model, Point point) {
        List<Object> nodes = this._finder.apply(model, point);
        nodes.forEach(node -> this._actions.forEach(action -> action.accept(node)));
        if (this._shouldClone) {
            nodes = nodes.stream().map(DefaultDocumentNodeFactory::clone).collect(Collectors.toList());
        }
        return nodes;
    }

    protected void addAction(Consumer<N> action) {
        this._actions.add(action);
    }
}

