/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.doc.api;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.keikai.doc.api.impl.node.PageType;
import java.util.Arrays;
import java.util.Objects;

public class Path
implements Comparable<Path> {
    private static final Path ROOT = new Path(-1, false, false, null, new int[0]);
    private final int _sectionIndex;
    private final boolean _inHeader;
    private final boolean _inFooter;
    private final PageType _pageType;
    private final int[] _relativePath;

    @JsonCreator
    private Path(@JsonProperty(value="sectionIndex") int sectionIndex, @JsonProperty(value="inHeader") boolean inHeader, @JsonProperty(value="inFooter") boolean inFooter, @JsonProperty(value="pageType") PageType pageType, int ... relativePath) {
        this._sectionIndex = sectionIndex;
        this._inHeader = inHeader;
        this._inFooter = inFooter;
        this._pageType = pageType;
        this._relativePath = relativePath;
    }

    public static Path of() {
        return ROOT;
    }

    public static Path of(int sectionIndex, int ... relativePath) {
        if (sectionIndex == -1 && relativePath.length == 0) {
            return ROOT;
        }
        if (Path.anyNegative(sectionIndex, relativePath)) {
            return null;
        }
        return new Path(sectionIndex, false, false, null, relativePath);
    }

    public static Path ofHeader(int sectionIndex, PageType pageType, int ... relativePath) {
        if (Path.anyNegative(sectionIndex, relativePath)) {
            return null;
        }
        return new Path(sectionIndex, true, false, pageType, relativePath);
    }

    public static Path ofFooter(int sectionIndex, PageType pageType, int ... relativePath) {
        if (Path.anyNegative(sectionIndex, relativePath)) {
            return null;
        }
        return new Path(sectionIndex, false, true, pageType, relativePath);
    }

    private static boolean anyNegative(int sectionIndex, int ... relativePath) {
        return sectionIndex < 0 || Arrays.stream(relativePath).anyMatch(i -> i < 0);
    }

    public int getSectionIndex() {
        return this._sectionIndex;
    }

    public boolean isInHeader() {
        return this._inHeader;
    }

    public boolean isInFooter() {
        return this._inFooter;
    }

    public PageType getPageType() {
        return this._pageType;
    }

    @JsonIgnore
    public int getDepth() {
        return this._relativePath.length;
    }

    public int[] getRelativePath() {
        return Arrays.copyOf(this._relativePath, this._relativePath.length);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Path path = (Path)o;
        return this._sectionIndex == path._sectionIndex && this._inHeader == path._inHeader && this._inFooter == path._inFooter && this._pageType == path._pageType && Arrays.equals(this._relativePath, path._relativePath);
    }

    @Override
    public int compareTo(Path o) {
        if (this._sectionIndex != o._sectionIndex) {
            return Integer.compare(this._sectionIndex, o._sectionIndex);
        }
        for (int i = 0; i < Math.min(this._relativePath.length, o._relativePath.length); ++i) {
            if (this._relativePath[i] == o._relativePath[i]) continue;
            return Integer.compare(this._relativePath[i], o._relativePath[i]);
        }
        return 0;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this._sectionIndex, this._inHeader, this._inFooter, this._pageType, Arrays.hashCode(this._relativePath)});
    }

    public String toString() {
        String s = "Path.of(" + this._sectionIndex;
        if (this.isInHeader()) {
            s = "Path.ofHeader(" + this._sectionIndex + ", " + this._pageType;
        } else if (this.isInFooter()) {
            s = "Path.ofFooter(" + this._sectionIndex + ", " + this._pageType;
        }
        return s + ", " + Arrays.toString(this._relativePath) + ")";
    }

    @JsonIgnore
    public int getLastIndex() {
        if (this.getDepth() == 0) {
            return ROOT.equals(this) || this._inHeader || this._inFooter ? -1 : this._sectionIndex;
        }
        return this._relativePath[this._relativePath.length - 1];
    }

    @JsonIgnore
    public Path getParent() {
        if (ROOT.equals(this)) {
            return null;
        }
        if (this.getDepth() == 0) {
            return this._inHeader || this._inFooter ? Path.of(this._sectionIndex, new int[0]) : ROOT;
        }
        int[] newRelativePath = Arrays.copyOf(this._relativePath, this._relativePath.length - 1);
        return new Path(this._sectionIndex, this._inHeader, this._inFooter, this._pageType, newRelativePath);
    }

    private Path getSibling(int delta) {
        if (this.getDepth() == 0) {
            return ROOT.equals(this) || this._inHeader || this._inFooter ? null : Path.of(this._sectionIndex + delta, new int[0]);
        }
        int[] newRelativePath = Arrays.copyOf(this._relativePath, this._relativePath.length);
        int n = newRelativePath.length - 1;
        newRelativePath[n] = newRelativePath[n] + delta;
        return new Path(this._sectionIndex, this._inHeader, this._inFooter, this._pageType, newRelativePath);
    }

    @JsonIgnore
    public Path getPreviousSibling() {
        return this.getSibling(-1);
    }

    @JsonIgnore
    public Path getNextSibling() {
        return this.getSibling(1);
    }

    public Path getChild(int childIndex) {
        if (ROOT.equals(this)) {
            return Path.of(childIndex, new int[0]);
        }
        int[] newRelativePath = Arrays.copyOf(this._relativePath, this._relativePath.length + 1);
        newRelativePath[newRelativePath.length - 1] = childIndex;
        return new Path(this._sectionIndex, this._inHeader, this._inFooter, this._pageType, newRelativePath);
    }

    public Path withRelativePath(int ... relativePath) {
        return new Path(this._sectionIndex, this._inHeader, this._inFooter, this._pageType, relativePath);
    }
}

