export * from '.';
export as namespace kkdoc;
import {Point} from 'slate';
import {
    TDescendant,
    TInsertNodeOperation,
    TInsertTextOperation,
    TMergeNodeOperation,
    TMoveNodeOperation,
    TRemoveNodeOperation,
    TRemoveTextOperation,
    TSetNodeOperation,
    TSplitNodeOperation
} from '@udecode/plate-common';

declare global {
    export type TElement = import('@udecode/plate-common').TElement;

    export type KOperation<N extends TDescendant = TDescendant> =
        KInsertNodeOperation<N>
        | KInsertTextOperation
        | KMergeNodeOperation
        | KMoveNodeOperation
        | KRemoveNodeOperation<N>
        | KRemoveTextOperation
        | KSetNodeOperation
        | KSplitNodeOperation
        | KSetSelectionOperation;

    export interface KPath {
        sectionIndex: number;
        inHeader: boolean;
        inFooter: boolean;
        pageType?: string;
        relativePath: number[];
    }

    export type KPoint = Omit<Point, 'path'> & { path: KPath };

    export interface KRange {
        anchor: KPoint;
        focus: KPoint;
    }

    export type KInsertNodeOperation<N extends TDescendant = TDescendant>
        = Omit<TInsertNodeOperation<N>, 'path'> & { path: KPath };
    export type KInsertTextOperation = Omit<TInsertTextOperation, 'path'> & { path: KPath };
    export type KMergeNodeOperation = Omit<TMergeNodeOperation, 'path'> & { path: KPath };
    export type KMoveNodeOperation = Omit<TMoveNodeOperation, 'path' | 'newPath'> & { path: KPath; newPath: KPath };
    export type KRemoveNodeOperation<N extends TDescendant = TDescendant>
        = Omit<TRemoveNodeOperation<N>, 'path'> & { path: KPath };
    export type KRemoveTextOperation = Omit<TRemoveTextOperation, 'path'> & { path: KPath };
    export type KSetNodeOperation = Omit<TSetNodeOperation, 'path'> & { path: KPath };
    export type KSplitNodeOperation = Omit<TSplitNodeOperation, 'path'> & { path: KPath };

    export interface KSetSelectionOperation {
        type: 'set_selection';
        properties: undefined;
        newProperties: KRange;

        [key: string]: unknown;
    }
}
