// Elements generated with npx @udecode/plate-ui@latest

import {withProps} from '@udecode/cn';
import {
    MARK_BOLD,
    MARK_CODE,
    MARK_ITALIC,
    MARK_STRIKETHROUGH,
    MARK_SUBSCRIPT,
    MARK_SUPERSCRIPT,
    MARK_UNDERLINE
} from '@udecode/plate-basic-marks';
import {PlateElement, PlateLeaf, PlatePluginComponent} from '@udecode/plate-common';
import {ELEMENT_H1, ELEMENT_H2, ELEMENT_H3, ELEMENT_H4, ELEMENT_H5, ELEMENT_H6} from '@udecode/plate-heading';
import {ELEMENT_PARAGRAPH} from '@udecode/plate-paragraph';
import {HeadingElement} from '@plate/components/heading-element';
import {TableElement} from '@plate/components/table-element';
import {ELEMENT_TABLE, ELEMENT_TD, ELEMENT_TH, ELEMENT_TR} from '@udecode/plate-table';
import {TableRowElement} from '@plate/components/table-row-element';
import {TableCellElement, TableCellHeaderElement} from '@plate/components/table-cell-element';
import {
    ELEMENT_FOOTER,
    ELEMENT_HEADER,
    ELEMENT_PAGE_NUMBER,
    ELEMENT_PAGE_BREAK,
    ELEMENT_SECTION,
    ELEMENT_ROOT
} from '@plate/plugins/plate-pagination';
import {HrElement} from '@plate/components/hr-element';
import {ELEMENT_HR} from '@udecode/plate-horizontal-rule';
import {HeaderFooterElement} from '@plate/components/header-footer-element';
import {CodeLeaf} from '@plate/components/code-leaf';
import {MARK_HIGHLIGHT} from '@udecode/plate-highlight';
import {HighlightLeaf} from '@plate/components/highlight-leaf';
import {MARK_KBD} from '@udecode/plate-kbd';
import {KbdLeaf} from '@plate/components/kbd-leaf';
import {MentionElement} from '@plate/components/mention-element';
import {SectionElement} from '@plate/components/section-element';
import {ParagraphElement} from '@plate/components/paragraph-element';
import {ELEMENT_COMPONENT} from '@plate/plugins/plate-component';
import {ComponentElement} from '@plate/components/component-element';
import {RootElement} from '@plate/components/root-element';

export const createPlateUI = (
    zclass: string, overrideByKey?: Partial<Record<string, PlatePluginComponent>>
): Record<string, PlatePluginComponent> => {
    const components: Record<string, PlatePluginComponent> = {
        [ELEMENT_H1]: withProps(HeadingElement, {variant: 'h1', className: `${zclass}-${ELEMENT_H1}`}),
        [ELEMENT_H2]: withProps(HeadingElement, {variant: 'h2', className: `${zclass}-${ELEMENT_H2}`}),
        [ELEMENT_H3]: withProps(HeadingElement, {variant: 'h3', className: `${zclass}-${ELEMENT_H3}`}),
        [ELEMENT_H4]: withProps(HeadingElement, {variant: 'h4', className: `${zclass}-${ELEMENT_H4}`}),
        [ELEMENT_H5]: withProps(HeadingElement, {variant: 'h5', className: `${zclass}-${ELEMENT_H5}`}),
        [ELEMENT_H6]: withProps(HeadingElement, {variant: 'h6', className: `${zclass}-${ELEMENT_H6}`}),
        [ELEMENT_PARAGRAPH]: withProps(ParagraphElement, {className: `${zclass}-${ELEMENT_PARAGRAPH}`}),
        [ELEMENT_COMPONENT]: withProps(ComponentElement, {className: `${zclass}-${ELEMENT_COMPONENT}`}),
        [ELEMENT_TABLE]: withProps(TableElement, {className: `${zclass}-${ELEMENT_TABLE}`}),
        [ELEMENT_TR]: withProps(TableRowElement, {className: `${zclass}-${ELEMENT_TR}`}),
        [ELEMENT_TH]: withProps(TableCellHeaderElement, {className: `${zclass}-${ELEMENT_TH}`}),
        [ELEMENT_TD]: withProps(TableCellElement, {className: `${zclass}-${ELEMENT_TD}`}),

        [ELEMENT_ROOT]: withProps(RootElement, {className: `${zclass}-${ELEMENT_ROOT}`}),
        [ELEMENT_SECTION]: withProps(SectionElement, {className: `${zclass}-${ELEMENT_SECTION}`}),
        [ELEMENT_PAGE_BREAK]: withProps(PlateElement, {className: `${zclass}-${ELEMENT_PAGE_BREAK}`}),
        [ELEMENT_HEADER]: withProps(HeaderFooterElement, {className: `${zclass}-${ELEMENT_HEADER}`}),
        [ELEMENT_FOOTER]: withProps(HeaderFooterElement, {className: `${zclass}-${ELEMENT_FOOTER}`}),
        [ELEMENT_PAGE_NUMBER]: withProps(MentionElement, {className: `${zclass}-${ELEMENT_PAGE_NUMBER}`}),
        [ELEMENT_HR]: withProps(HrElement, {className: `${zclass}-${ELEMENT_HR}`}),

        [MARK_BOLD]: withProps(PlateLeaf, {as: 'strong', className: `${zclass}-${MARK_BOLD}`}),
        [MARK_CODE]: withProps(CodeLeaf, {className: `${zclass}-${MARK_CODE}`}),
        [MARK_HIGHLIGHT]: withProps(HighlightLeaf, {className: `${zclass}-${MARK_HIGHLIGHT}`}),
        [MARK_ITALIC]: withProps(PlateLeaf, {as: 'em', className: `${zclass}-${MARK_ITALIC}`}),
        [MARK_KBD]: withProps(KbdLeaf, {className: `${zclass}-${MARK_KBD}`}),
        [MARK_STRIKETHROUGH]: withProps(PlateLeaf, {as: 's', className: `${zclass}-${MARK_STRIKETHROUGH}`}),
        [MARK_SUBSCRIPT]: withProps(PlateLeaf, {as: 'sub', className: `${zclass}-${MARK_SUBSCRIPT}`}),
        [MARK_SUPERSCRIPT]: withProps(PlateLeaf, {as: 'sup', className: `${zclass}-${MARK_SUPERSCRIPT}`}),
        [MARK_UNDERLINE]: withProps(PlateLeaf, {as: 'u', className: `${zclass}-${MARK_UNDERLINE}`})
    };

    if (overrideByKey) {
        Object.keys(overrideByKey).forEach((key) => {
            components[key] = overrideByKey[key]!;
        });
    }

    return components;
};
