import * as React from 'react';

import {withRef} from '@udecode/cn';
import {PlateElement} from '@udecode/plate-common';

export const TableRowElement = withRef<
    typeof PlateElement,
    {
        hideBorder?: boolean;
    }
>(({children, hideBorder, style, ...props}, ref) => {
    const ghost = React.useMemo(() => <span className='ghost' contentEditable={false}/>, []);
    return (
        <PlateElement
            asChild
            style={{
                ...style,
                borderStyle: hideBorder ? 'none' : undefined,
                height: '100%', /* h-full */
                position: 'relative',
            }}
            // @ts-expect-error ignore
            ref={ref}
            {...props}
        >
            <tr>
                {ghost}
                {children}
            </tr>
        </PlateElement>
    );
});
