import * as React from 'react';

import {cn, withRef} from '@udecode/cn';
import {PlateElement, withHOC,} from '@udecode/plate-common';
import {TableProvider, useTableElement, useTableElementState,} from '@udecode/plate-table';

export const TableElement = withHOC(
    TableProvider,
    withRef<typeof PlateElement>(({children, className, style, ...props}, ref) => {
        const {colSizes, isSelectingCell, marginLeft} = useTableElementState(),
            {colGroupProps, props: tableProps} = useTableElement(),
            ghost = React.useMemo(() => <span className='ghost' contentEditable={false}/>, []);

        return (
            <div style={{paddingLeft: marginLeft}}>
                <PlateElement
                    asChild
                    className={cn(isSelectingCell && '[&_*::selection]:bg-none', className)}
                    // @ts-expect-error ignore
                    ref={ref}
                    style={{
                        ...style,
                        /* my-4 ml-px mr-0 table h-px w-full table-fixed border-collapse */
                        margin: '1rem 0 1rem 1px',
                        width: '100%',
                        height: '1px',
                        borderCollapse: 'collapse',
                        tableLayout: 'fixed',
                        position: 'relative',
                    }}
                    {...tableProps}
                    {...props}
                >
                    <table>
                        {ghost}
                        <colgroup {...colGroupProps}>
                            {/* hide ghost in TR */}
                            <col style={{width: 0}}/>
                            {colSizes.map((width, index) => (
                                <col
                                    key={index}
                                    style={{
                                        width: width || undefined,
                                    }}
                                />
                            ))}
                        </colgroup>

                        <tbody style={{minWidth: '100%' /* min-w-full */}}>{children}</tbody>
                    </table>
                </PlateElement>
            </div>
        );
    })
);
