import * as React from 'react';
import {withRef} from '@udecode/cn';
import {PlateElement, useElement} from '@udecode/plate-common';

export const SectionElement = withRef<typeof PlateElement>(
    ({nodeProps, ...props}, ref) => {
        // eslint-disable-next-line @typescript-eslint/no-unsafe-assignment
        const {pageWidth, marginLeft, marginRight} = useElement(), {children} = props,
            ghost = React.useMemo(() => <span className='ghost' contentEditable={false}/>, []);
        return (
            // @ts-expect-error ignore
            <PlateElement ref={ref} {...props}
                          style={{
                              border: '1px solid black',
                              boxSizing: 'border-box',
                              width: `${pageWidth as number}cm`,
                              paddingLeft: `${marginLeft as number}cm`,
                              paddingRight: `${marginRight as number}cm`,
                              position: 'relative',
                              overflow: 'visible',
                              zIndex: 0,
                          }}>
                {ghost}
                {children}
            </PlateElement>
        );
    }
);
