'use client';

import * as React from 'react';

import {cn, withRef, withVariants} from '@udecode/cn';
import {Resizable as ResizablePrimitive, ResizeHandle as ResizeHandlePrimitive,} from '@udecode/plate-resizable';
import {cva} from 'class-variance-authority';

export const mediaResizeHandleVariants = cva(
    cn(
        'top-0 flex w-6 select-none flex-col justify-center',
        "after:flex after:h-16 after:w-[3px] after:rounded-[6px] after:bg-ring after:opacity-0 after:content-['_'] group-hover:after:opacity-100"
    ),
    {
        variants: {
            direction: {
                left: '-left-3 -ml-3 pl-3',
                right: '-right-3 -mr-3 items-end pr-3',
            },
        },
    }
);

const resizeHandleVariants = cva(cn(''), {
        variants: {
            direction: {
                bottom: '',
                left: '',
                right: '',
                top: '',
            },
        },
    }),

    ResizeHandleVariants = withVariants(
        ResizeHandlePrimitive,
        resizeHandleVariants,
        ['direction']
    );

export const ResizeHandle = withRef<typeof ResizeHandlePrimitive>(
    ({style, ...props}, ref) => {
        const direction = props.options?.direction;
        return (
            <ResizeHandleVariants
                direction={direction}
                style={{
                    /* absolute z-40 */
                    position: 'absolute',
                    zIndex: 40,
                    /* h-full cursor-col-resize or w-full cursor-row-resize */
                    cursor: direction === 'left' || direction === 'right' ? 'col-resize' : 'row-resize',
                    height: direction === 'left' || direction === 'right' ? '100%' : undefined,
                    width: direction === 'top' || direction === 'bottom' ? '100%' : undefined,
                    ...style
                }}
                // @ts-expect-error ignore
                ref={ref}
                {...props}
            />
        );
    });

const resizableVariants = cva('', {
    variants: {
        align: {
            center: 'mx-auto',
            left: 'mr-auto',
            right: 'ml-auto',
        },
    },
});

export const Resizable = withVariants(ResizablePrimitive, resizableVariants, [
    'align',
]);
