import * as React from 'react';

import {withRef} from '@udecode/cn';
import {PlateElement} from '@udecode/plate-common';

export const ParagraphElement = withRef<typeof PlateElement>(
    ({children, style, ...props}, ref) => {
        const ghost = React.useMemo(() => <span className='ghost' contentEditable={false}/>, []);
        return (
            // @ts-expect-error ignore
            <PlateElement ref={ref} style={{...style, position: 'relative'}} {...props}>
                {ghost}
                {children}
            </PlateElement>
        );
    });
