import * as React from 'react';

import type {TMentionElement} from '@udecode/plate-mention';

import {withRef} from '@udecode/cn';
import {getHandler, PlateElement, useElement} from '@udecode/plate-common';
import {useFocused, useSelected} from 'slate-react';

export const MentionElement = withRef<
    typeof PlateElement,
    {
        onClick?: (mentionNode: unknown) => void;
        prefix?: string;
        renderLabel?: (mentionable: TMentionElement) => string;
    }
>(({children, style, onClick, prefix, renderLabel, ...props}, ref) => {
    const element = useElement<TMentionElement>(),
        selected = useSelected(),
        focused = useFocused();

    return (
        <PlateElement
            style={{
                ...style,
                /* ring-2 ring-ring */
                boxShadow: selected && focused ?
                    'rgb(255, 255, 255) 0px 0px 0px 0px, ' +
                    'rgb(148, 163, 184) 0px 0px 0px 2px, ' +
                    'rgba(0, 0, 0, 0) 0px 0px 0px 0px' : undefined,
                display: 'inline-block',
                cursor: 'pointer',
                borderRadius: '0.375rem',
                backgroundColor: 'rgb(241, 245, 249)',
                paddingLeft: '0.375rem',
                paddingRight: '0.375rem',
                paddingTop: '0.125rem',
                paddingBottom: '0.125rem',
                verticalAlign: 'baseline',
                fontSize: '0.875rem',
                lineHeight: '1.25rem',
                fontWeight: '500'
            }}
            contentEditable={false}
            data-slate-value={element.value}
            onClick={getHandler(onClick, element)}
            // @ts-expect-error ignore
            ref={ref}
            {...props}
        >
            {children}
        </PlateElement>
    );
});
