import * as React from 'react';

import {withRef} from '@udecode/cn';
import {PlateLeaf} from '@udecode/plate-common';

export const KbdLeaf = withRef<typeof PlateLeaf>(
    ({children, style, ...props}, ref) => (
        <PlateLeaf
            asChild
            style={{
                ...style,
                borderRadius: '0.25rem',
                borderColor: '#e2e8f0',
                borderStyle: 'solid',
                borderWidth: '1px',
                backgroundColor: '#f1f5f9',
                paddingTop: '0.125rem',
                paddingBottom: '0.125rem',
                paddingLeft: '0.375rem',
                paddingRight: '0.375rem',
                fontFamily: 'Menlo, Monaco, Consolas, "Liberation Mono", "Courier New", monospace',
                fontSize: '0.875rem',
                lineHeight: '1.25rem',
                boxShadow: 'rgba(255, 255, 255, 0.1) 0px 0.5px 0px 0px inset, ' +
                    'rgb(248, 249, 250) 0px 1px 5px 0px inset, ' +
                    'rgb(193, 200, 205) 0px 0px 0px 0.5px, ' +
                    'rgb(193, 200, 205) 0px 2px 1px -1px, ' +
                    'rgb(193, 200, 205) 0px 1px 0px 0px'
            }}
            // @ts-expect-error ignore
            ref={ref}
            {...props}
        >
            <kbd>{children}</kbd>
        </PlateLeaf>
    )
);
