import * as React from 'react';

import {cn, withRef} from '@udecode/cn';
import {PlateElement, useElement} from '@udecode/plate-common';
import {useFocused, useSelected} from 'slate-react';
import {ELEMENT_SECTION} from '@plate/plugins/plate-pagination';

export const HrElement = withRef<typeof PlateElement>(
    ({className, nodeProps, ...props}, ref) => {
        // eslint-disable-next-line @typescript-eslint/no-unsafe-assignment
        const {children} = props,
            {marginLeft, marginRight} = useElement(ELEMENT_SECTION),
            selected = useSelected(),
            focused = useFocused();

        return (
            // @ts-expect-error ignore
            <PlateElement ref={ref} {...props}>
                <div className="py-6" contentEditable={false}>
                    <hr
                        {...nodeProps}
                        className={cn(
                            'h-0.5 cursor-pointer rounded-sm border-none bg-muted bg-clip-content',
                            selected && focused && 'ring-2 ring-ring ring-offset-2',
                            className
                        )}
                        style={{
                            marginLeft: `-${marginLeft as number}cm`,
                            marginRight: `-${marginRight as number}cm`
                        }}
                    />
                </div>
                {children}
            </PlateElement>
        );
    }
);
