import * as React from 'react';

import {withRef} from '@udecode/cn';
import {PlateLeaf} from '@udecode/plate-common';

export const HighlightLeaf = withRef<typeof PlateLeaf>(
    ({children, style, ...props}, ref) => (
        <PlateLeaf
            asChild
            style={{
                ...style,
                backgroundColor: 'rgba(15, 23, 42, 0.2)',
                color: 'inherit',
            }}
            // @ts-expect-error ignore
            ref={ref}
            {...props}
        >
            <mark>{children}</mark>
        </PlateLeaf>
    )
);
