import * as React from 'react';

import {withRef, withVariants} from '@udecode/cn';
import {PlateElement} from '@udecode/plate-common';
import {cva} from 'class-variance-authority';

const headingVariants = cva('', {
        variants: {
            isFirstBlock: {
                false: '',
                true: '',
            },
            variant: {
                h1: '',
                h2: '',
                h3: '',
                h4: '',
                h5: '',
                h6: '',
            },
        },
    }),

    HeadingElementVariants = withVariants(PlateElement, headingVariants, [
        'isFirstBlock',
        'variant',
    ]);

export const HeadingElement = withRef<typeof HeadingElementVariants>(
    ({children, isFirstBlock, variant = 'h1', ...props}, ref) => {
        const {editor, element} = props,
            Element = variant!;
        return (
            <HeadingElementVariants
                asChild
                isFirstBlock={element === editor.children[0]}
                // @ts-expect-error ignore
                ref={ref}
                variant={variant}
                {...props}
            >
                <Element>{children}</Element>
            </HeadingElementVariants>
        );
    }
);
