import * as React from 'react';

import {withRef} from '@udecode/cn';
import {PlateElement, useElement} from '@udecode/plate-common';
import {ELEMENT_HEADER, ELEMENT_SECTION} from '@plate/plugins/plate-pagination';

export const HeaderFooterElement = withRef<typeof PlateElement>(
    ({children, ...props}, ref) => {
        const {type} = useElement(),
            {marginTop, marginBottom} = useElement(ELEMENT_SECTION),
            height = (type === ELEMENT_HEADER ? marginTop : marginBottom) as number,
            ghost = React.useMemo(() => <span className='ghost' contentEditable={false}/>, []);

        return (
            // @ts-expect-error ignore
            <PlateElement ref={ref} {...props} style={{height: `${height}cm`, position: 'relative'}}>
                {ghost}
                {children}
            </PlateElement>
        );
    }
);
