import * as React from 'react';

import type {PlateContentProps} from '@udecode/plate-common';
import {PlateContent} from '@udecode/plate-common';
import type {VariantProps} from 'class-variance-authority';
import {cva} from 'class-variance-authority';

import {cn} from '@udecode/cn';

const editorVariants = cva(
    cn(
        ''
    ),
    {
        defaultVariants: {
            focusRing: true,
            size: 'sm',
            variant: 'outline',
        },
        variants: {
            disabled: {
                true: 'cursor-not-allowed opacity-50',
            },
            focusRing: {
                false: '',
                true: 'focus-visible:ring-2 focus-visible:ring-ring focus-visible:ring-offset-2',
            },
            focused: {
                true: 'ring-2 ring-ring ring-offset-2',
            },
            size: {
                md: 'text-base',
                sm: 'text-sm',
            },
            variant: {
                ghost: '',
                outline: 'border border-input',
            },
        },
    }
);

export type EditorProps = PlateContentProps &
    VariantProps<typeof editorVariants>;

const Editor = React.forwardRef<HTMLDivElement, EditorProps>(
    (
        {
            className,
            disabled,
            focusRing,
            focused,
            readOnly,
            size,
            style,
            variant,
            ...props
        },
        ref
    ) => {
        return (
            <div ref={ref}
                 style={{
                     /* relative w-full */
                     position: 'relative',
                     width: '100%',
                 }}>
                <PlateContent
                    aria-disabled={disabled}
                    className={cn(
                        editorVariants({
                            disabled,
                            focusRing,
                            focused,
                            size,
                            variant,
                        }),
                        className
                    )}
                    style={{
                        ...style,
                        /* relative overflow-x-auto whitespace-pre-wrap break-words */
                        position: 'relative',
                        whiteSpace: 'pre-wrap',
                        overflowWrap: 'break-word',
                        /* min-h-[80px] w-full rounded-md bg-background px-3 py-2 text-sm ring-offset-background placeholder:text-muted-foreground focus-visible:outline-none */
                    }}
                    disableDefaultStyles
                    readOnly={disabled ?? readOnly}
                    {...props}
                />
            </div>
        );
    }
);
Editor.displayName = 'Editor';

export {Editor};
