'use client';

import * as React from 'react';

import {withRef} from '@udecode/cn';
import {PlateLeaf} from '@udecode/plate-common';

export const CodeLeaf = withRef<typeof PlateLeaf>(
    ({children, style, ...props}, ref) => {
        return (
            <PlateLeaf
                asChild
                style={{
                    ...style,
                    whiteSpace: 'pre-wrap',
                    borderRadius: '0.375rem',
                    backgroundColor: '#f1f5f9',
                    paddingLeft: '0.3rem',
                    paddingRight: '0.3rem',
                    paddingTop: '0.2rem',
                    paddingBottom: '0.2rem',
                    fontFamily: 'Menlo, Monaco, Consolas, "Liberation Mono", "Courier New", monospace',
                    lineHeight: '1.25rem'
                }}
                // @ts-expect-error ignore
                ref={ref}
                {...props}
            >
                <code>{children}</code>
            </PlateLeaf>
        );
    }
);
