@zk.WrapClass('kkdoc.Docpad')
export class Docpad extends zul.Widget {
    /** @internal */
    _plate?: kkdoc.PlateObject;
    /** @internal */
    _value?: TElement;
    /** @internal */
    _showMainToolbar?: boolean;
    /** @internal */
    _mainToolbarContainer?: zul.wgt.Div;
    /** @internal */
    _editorContainer?: zul.wgt.Div;
    /** @internal */
    _popupToolbarContainer?: zul.wgt.Popup;

    getValue(): TElement | undefined {
        return this._value;
    }

    setValue(value: TElement, opts?: Record<string, boolean>): this {
        const o = this._value;
        this._value = value;
        if (this.desktop && (o !== value || opts?.force)) {
            this._plate?.setValue(value);
        }
        return this;
    }

    setApply(apply: KOperation[]): this {
        this._plate?.applyOperation(apply);
        return this;
    }

    setShowMainToolbar(showMainToolbar: boolean): this {
        if (this._showMainToolbar !== showMainToolbar) {
            this._showMainToolbar = showMainToolbar;
            this._updateHeight();
        }
        return this;
    }

    /** @internal */
    _updateHeight(): void {
        if (this.desktop && this._mainToolbarContainer && this._editorContainer) {
            const docpadHeight = this.$n()!.offsetHeight,
                toolbarHeight = this._mainToolbarContainer.$n() !== undefined ? this._mainToolbarContainer.$n()!.offsetHeight : 0,
                editorHeight = docpadHeight - toolbarHeight;
            this._editorContainer.setHeight(editorHeight + 'px');
        }
    }

    /** @internal */
    // eslint-disable-next-line @typescript-eslint/ban-ts-comment
	// @ts-expect-error wait for zk-types to fix for protected methods.
    override bind_(desktop?: zk.Desktop, skipper?: zk.Skipper, after?: CallableFunction[]): void {
        // eslint-disable-next-line @typescript-eslint/ban-ts-comment
		// @ts-expect-error wait for zk-types to fix for protected methods.
		// eslint-disable-next-line @typescript-eslint/no-unsafe-call
        super.bind_(desktop, skipper, after); // TODO fix bind_ doesn't exist on Widget
        this._mainToolbarContainer = this.getChildAt(0) as zul.wgt.Div;
        this._editorContainer = this.getChildAt(1) as zul.wgt.Div;
        this._popupToolbarContainer = this.getChildAt(2) as zul.wgt.Popup;
        this._updateHeight();
        this._plate = new kkdoc.PlateObject(this.getChildAt(1)!.uuid, /*safe*/ this.getZclass(), this._value!,
                                            this._onChange.bind(this), this._onEditorMouseUp.bind(this));
    }

    /** @internal */
    // eslint-disable-next-line @typescript-eslint/ban-ts-comment
    // @ts-expect-error wait for zk-types to fix for protected methods.
    override unbind_(skipper?: zk.Skipper, after?: CallableFunction[], keepRod?: boolean): void {
        this._plate = undefined;
        this._mainToolbarContainer = this._editorContainer = this._popupToolbarContainer = undefined;
        // eslint-disable-next-line @typescript-eslint/ban-ts-comment
		// @ts-expect-error wait for zk-types to fix for protected methods.
		// eslint-disable-next-line @typescript-eslint/no-unsafe-call
        super.unbind_(skipper, after, keepRod);
    }

    /** @internal */
    _onChange(operations: KOperation[]): void {
        this.fire('onChanging', {operations});
    }

    /** @internal */
    _onEditorMouseUp(): void {
        this.fire('onEditorMouseUp');
    }

    /** @internal */
    // eslint-disable-next-line @typescript-eslint/ban-ts-comment
    // @ts-expect-error wait for zk-types to fix for protected methods.
    override focus_(timeout?: number): boolean {
        return !!this._plate?.focus() || false;
    }
}
