/*
 * Decompiled with CFR 0.152.
 */
package io.keikaiex.rt;

import io.keikai.doc.ui.Docpad;
import io.keikaiex.license.LicenseContent;
import io.keikaiex.rt.Runtime;
import io.keikaiex.rt.RuntimeLicenseManager;
import io.keikaiex.util.ObfuscatedString;
import java.math.BigInteger;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.zkoss.lang.Library;
import org.zkoss.util.Dates;
import org.zkoss.util.resource.Locator;
import org.zkoss.util.resource.Locators;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.au.out.AuAlert;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.WebApp;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.util.DesktopCleanup;
import org.zkoss.zk.ui.util.DesktopInit;
import org.zkoss.zk.ui.util.EventInterceptor;
import org.zkoss.zk.ui.util.ExecutionInit;

public final class DocumentRuntime
extends Runtime {
    public static final String WARNING_EVALUATION = new ObfuscatedString(new long[]{-1389119026487455272L, 9131752314957408038L, 8338537987390204203L, 2361790775223484951L, 3803443771705665778L, 8641807871260227L, 2567427691121877503L, -8372318018774695304L, 1256906032403255365L, -6358669418247073178L, 4952059767975870851L, -9102088098839924863L, 7280705810995269541L, 6461397657924230501L, 4894735901564209009L, 3234179268518302836L, 741300154245106894L, 5103392515074142687L, -6580036368448948275L, -2673315108213669769L, 6608211288913522705L, 7542864840394481811L, 5066418386303024411L, -3406383931890407623L, -6024924537204224474L, 5591829462416032667L, -184605192810089014L, -880768179984281950L, 4230496551116481626L, 8829146280231134545L, -376339102599280745L, 3541492921063360047L, -5047440554926601056L, 1347389642496013634L, -3374752985811083925L}).toString();
    private static final String KEIKAI_DOCUMENT = new ObfuscatedString(new long[]{-8036514539383214885L, 1594962736698805374L, 1544233177077133803L}).toString();
    private static WebApp _wapp;
    private static final Locator LOCATOR;
    private static final Init1 _init1;

    protected String getEvalNotice(WebApp webApp) {
        StringBuffer sb = new StringBuffer();
        Object o = webApp.getAttribute(ZK_NOTICE);
        if (o != null) {
            sb.append(o);
        }
        sb.append(" -->\n").append("<!-- ").append(KEIKAI_DOCUMENT).append(" ").append("7.0.0.FL.20241004").append(" PE ");
        sb.append(EVAL_ONLY);
        return sb.toString();
    }

    protected Class getInitClass() {
        return Init.class;
    }

    protected boolean init1(WebApp wapp) throws Exception {
        _wapp = wapp;
        wapp.getConfiguration().addListener(Init.class);
        String dir = Library.getProperty((String)LICENSE_DIRECTORY_PROPERTY);
        boolean isScheduled = false;
        URL url = dir != null ? DocumentRuntime.getURLFromString((String)dir) : LOCATOR.getResource(DEFAULT_LICENSE_DIRECTORY);
        RuntimeLicenseManager licenseManager = DocumentRuntime.getLicenseManager();
        if (url != null) {
            isScheduled = licenseManager.install(url);
        }
        if (isScheduled) {
            licenseManager.setWapp(wapp);
            licenseManager.startScheduler();
            return true;
        }
        DocumentRuntime.init1().init2(null);
        return false;
    }

    private static Init1 init1() {
        return _init1;
    }

    protected void refresh(List contents) {
        DocumentRuntime.init1().init2(contents);
    }

    public boolean isTargetSubject(String subject) {
        return super.isTargetSubject(subject) || KEIKAI_DOCUMENT.equals(subject);
    }

    static {
        LOCATOR = Locators.getDefault();
        _init1 = new Init1();
    }

    private static final class Init1 {
        private static final int FREQ = 3;
        private boolean _stoplicense;
        private boolean _stopuptime;
        private int _inModal;
        private final long _uptime = new Date().getTime();
        private static final Init2 _init2 = new Init2();
        private static final String UPTIME_EXP = new ObfuscatedString(new long[]{-4293378014864983854L, -3103480772416414863L, -669829065550230761L, 8621437062220798079L, -6475848753964365826L, -1689972928343838940L, 2578977671568169052L, 2135199706560379821L}).toString();
        private static final String TRIAL_EXP = new ObfuscatedString(new long[]{5785893743851046618L, -1038386247842605644L, -1587647629413799593L, -4139549328795795680L, -5140457065968663888L, 4811674114121141330L, 6358176554697626341L}).toString();
        private static final String EVAL_NOTICE = new ObfuscatedString(new long[]{-5420636701539265502L, 7076357681677543342L, -4371239697477747486L, -1007401330690845244L, 4506816676574350748L}).toString();

        private Init1() {
        }

        private void init2(List contents) {
            _init2.init2(contents);
            Runtime._pass.set(!Init1._init2._keys.isEmpty());
        }

        private void init2(Execution exec, Execution parent) {
            Runtime.token0((Object)exec, (Object)exec);
        }

        private void afterProcessEvent0(Event event) {
            if (!this.validate(event)) {
                ++this._inModal;
            }
        }

        private Event beforePostEvent0(Event event) {
            return event;
        }

        private Event beforeProcessEvent0(Event event) {
            Component comp = event.getTarget();
            if (comp instanceof Docpad) {
                if (this._stopuptime) {
                    this.complainUptime(event);
                    return null;
                }
                if (this._stoplicense) {
                    this.complainLicense(event);
                    return null;
                }
            }
            return event;
        }

        private Event beforeSendEvent0(Event event) {
            return event;
        }

        private void init0(Desktop desktop, Object request) {
            Runtime.initToken((Desktop)desktop);
            Init init = new Init();
            desktop.setAttribute(Runtime.token1((Object)desktop), (Object)init);
            desktop.addListener((Object)init);
        }

        private void cleanup0(Desktop desktop) {
            Object init = desktop.getAttribute(Runtime.token1((Object)desktop));
            desktop.removeListener(init);
        }

        private boolean validate(Event event) {
            return !this.validUptime(event) || !this.validLicense(event);
        }

        private boolean validLicense(Event event) {
            if (Init1._init2._keys.isEmpty()) {
                this.complainLicense(event);
                return false;
            }
            long time = new Date().getTime();
            if (((Date)Init1._init2._validbegin).getTime() > time || time > ((Date)Init1._init2._validend).getTime()) {
                this.complainLicense(event);
                return false;
            }
            return true;
        }

        private boolean validUptime(Event event) {
            if (Init1._init2._keys.isEmpty() || Init1._init2._uptime == null) {
                this.complainLicense(event);
                return false;
            }
            long time = new Date().getTime();
            if (this._uptime > time || time > this._uptime + (Long)Init1._init2._uptime) {
                this.complainUptime(event);
                return false;
            }
            return true;
        }

        private void complainLicense(Event event) {
            Page pg;
            Component comp;
            ++this._inModal;
            if (!this._stoplicense && (this._inModal & 3) == 0 && (comp = event.getTarget()) instanceof Docpad && (pg = comp.getPage()) != null) {
                this._stoplicense = true;
                Runtime.error((String)TRIAL_EXP);
                Execution current = Executions.getCurrent();
                if (current != null) {
                    current.addAuResponse(TRIAL_EXP, (AuResponse)new AuAlert(TRIAL_EXP, EVAL_NOTICE, "z-msgbox z-uptime"));
                }
            }
        }

        private void complainUptime(Event event) {
            Page pg;
            Component comp;
            ++this._inModal;
            if (!this._stopuptime && (this._inModal & 3) == 0 && (comp = event.getTarget()) instanceof Docpad && (pg = comp.getPage()) != null) {
                this._stopuptime = true;
                Runtime.error((String)UPTIME_EXP);
                Execution current = Executions.getCurrent();
                if (current != null) {
                    current.addAuResponse(UPTIME_EXP, (AuResponse)new AuAlert(UPTIME_EXP, EVAL_NOTICE, "z-msgbox z-uptime"));
                }
            }
        }
    }

    public static final class Init
    extends Init0 {
        public void init(Desktop desktop, Object request) throws Exception {
            super.init0(desktop, request);
        }

        public void init(Execution exec, Execution parent) throws Exception {
            super.init2(exec, parent);
        }

        public void cleanup(Desktop desktop) throws Exception {
            super.cleanup0(desktop);
        }

        public void afterProcessEvent(Event event) {
            super.afterProcessEvent0(event);
        }

        public Event beforePostEvent(Event event) {
            return super.beforePostEvent0(event);
        }

        public Event beforeProcessEvent(Event event) {
            return super.beforeProcessEvent0(event);
        }

        public Event beforeSendEvent(Event event) {
            return super.beforeSendEvent0(event);
        }
    }

    protected static abstract class Init0
    implements ExecutionInit,
    DesktopInit,
    DesktopCleanup,
    EventInterceptor {
        private Init0() {
            this.init1();
        }

        private final void init0(Desktop desktop, Object request) throws Exception {
            this.init1().init0(desktop, request);
        }

        private final void cleanup0(Desktop desktop) throws Exception {
            this.init1().cleanup0(desktop);
        }

        private final void init2(Execution exec, Execution parent) throws Exception {
            this.init1().init2(exec, parent);
        }

        private final Init1 init1() {
            return _init1;
        }

        private final void afterProcessEvent0(Event event) {
            this.init1().afterProcessEvent0(event);
        }

        private final Event beforePostEvent0(Event event) {
            return this.init1().beforePostEvent0(event);
        }

        private Event beforeProcessEvent0(Event event) {
            return this.init1().beforeProcessEvent0(event);
        }

        private Event beforeSendEvent0(Event event) {
            return this.init1().beforeSendEvent0(event);
        }
    }

    private static final class Init2 {
        private static final BigInteger _pkey = new BigInteger("123");
        private static final String EVAL_LIC_ID = new ObfuscatedString(new long[]{-2799362229550136139L, -8991339801923478651L, 2054766831045471090L}).toString();
        private static final String EVAL_LIC_VER = new ObfuscatedString(new long[]{4515837249784318634L, -483965117545718936L}).toString();
        private static final String EVAL_USER_NAME = new ObfuscatedString(new long[]{6700787382705499563L, 2359114071391082446L, 1949693015831576717L}).toString();
        private static final String EVAL_COMPANY_ID = new ObfuscatedString(new long[]{8997629646135421336L, -7459597106373371040L, 3324566901651534592L}).toString();
        private static final String EVAL_COMPANY_NAME = new ObfuscatedString(new long[]{-7105953592593293452L, -8116579615415252408L, -3117127378177258899L, 9036340616621476990L}).toString();
        private static final Long EVAL_SESSION_COUNT = Long.MAX_VALUE;
        private final SimpleDateFormat _dateFormat = new SimpleDateFormat("MMMM dd, yyyy", Locale.US);
        private final Calendar _calendar = Calendar.getInstance();
        private Map _keys = new HashMap();
        private Object _licid;
        private Object _licversion;
        private Object _username;
        private Object _companyid;
        private Object _companyname;
        private Object _validbegin;
        private Object _validend;
        private Object _sessioncount;
        private Object _zssversion;
        private Object _uptime;

        private Init2() {
        }

        private Date getNotBefore(Map map) {
            try {
                return this._dateFormat.parse((String)map.get(Runtime.ISSUE_DATE));
            }
            catch (ParseException e) {
                return new Date(Long.MAX_VALUE);
            }
        }

        private Date getExpiryDate(Map map) {
            try {
                return this._dateFormat.parse((String)map.get(Runtime.EXPIRY_DATE));
            }
            catch (ParseException e) {
                return new Date(Long.MIN_VALUE);
            }
        }

        private long getSessionCount(LicenseContent lc) {
            return "Session".equalsIgnoreCase(lc.getConsumerType()) ? (long)lc.getConsumerAmount() : 0L;
        }

        private long getUpTime(Map map) {
            Long utime = (Long)map.get(Runtime.UP_TIME);
            return utime == null ? 0L : utime;
        }

        private void init2(List contents) {
            if (contents == null) {
                this.installEval();
                return;
            }
            String zssuid = "7.0.0.FL.20241004";
            Date today = Dates.today();
            boolean valid = false;
            Date mindate = new Date(Long.MAX_VALUE);
            Date maxdate = new Date(Long.MIN_VALUE);
            Date maxIssueDate = new Date(Long.MIN_VALUE);
            long sessionCount = 0L;
            long uptime = 0L;
            String machine = (String)_wapp.getAttribute(Runtime.ACTIVE_CODE);
            for (Object content : contents) {
                LicenseContent lc = (LicenseContent)content;
                Object mapobj = lc.getExtra();
                if (!(mapobj instanceof Map)) continue;
                Map map = (Map)mapobj;
                Date bdate = this.getNotBefore(map);
                Date edate = this.getExpiryDate(map);
                if (today.before(bdate) || today.after(edate)) continue;
                if (bdate.before(mindate)) {
                    mindate = bdate;
                }
                if (edate.after(maxdate)) {
                    maxdate = edate;
                }
                String activecode = (String)map.get(Runtime.ACTIVE_CODE);
                Date issueDate = lc.getIssued();
                if (!issueDate.after(maxIssueDate) || !Runtime.UNIVERSAL_ACTIVE_CODE.equals(activecode) && (machine == null || !machine.equals(activecode))) continue;
                valid = true;
                maxIssueDate = issueDate;
                this._zssversion = map.get(Runtime.VERSION);
                this._username = map.get(Runtime.USER_NAME);
                this._companyid = map.get(Runtime.COMPANY_ID);
                this._companyname = map.get(Runtime.COMPANY_NAME);
                this._keys = map;
                this._licid = map.get(Runtime.VERIFICATION_NUMBER);
                this._licversion = map.get(Runtime.LICENSE_VERSION);
                sessionCount += this.getSessionCount(lc);
                long utime = this.getUpTime(map);
                if (uptime >= utime) continue;
                uptime = utime;
            }
            if (valid) {
                this._validbegin = mindate;
                this._validend = maxdate;
                this._uptime = uptime <= 0L ? Long.valueOf(maxdate.getTime() - mindate.getTime() + (long)new SecureRandom(Runtime.longToByteArray((long)new Date().getTime())).nextInt(1800000)) : uptime;
                Object object = this._sessioncount = sessionCount > 0L ? Long.valueOf(sessionCount) : EVAL_SESSION_COUNT;
            }
            if (!valid || !this.validateLicenseFile()) {
                this.installEval();
            }
        }

        private void installEval() {
            this._username = EVAL_USER_NAME;
            this._companyid = EVAL_COMPANY_ID;
            this._companyname = EVAL_COMPANY_NAME;
            this._validbegin = new Date();
            this._uptime = (long)(43200000 + new SecureRandom(Runtime.longToByteArray((long)new Date().getTime())).nextInt(1800000));
            this._validend = new Date(((Date)this._validbegin).getTime() + (Long)this._uptime + 3600000L);
            this._sessioncount = EVAL_SESSION_COUNT;
            this._keys = new HashMap();
            this._keys.put(Runtime.COMPANY_ID, this._companyid);
        }

        private boolean validateLicenseFile() {
            return this._licid != null && this._licversion != null && this._username != null && this._companyid != null && this._companyname != null && this._validbegin != null && this._validend != null && this._sessioncount != null && this._zssversion != null && this._uptime != null;
        }

        private String encode(byte[] lic) {
            return new String(lic, StandardCharsets.UTF_8);
        }

        private byte[] decryption(byte[] lic) {
            return lic;
        }
    }
}

