/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.doc.ui.tool;

import io.keikai.doc.api.editor.Commands;
import io.keikai.doc.api.editor.Editor;
import io.keikai.doc.api.editor.SelectionView;
import io.keikai.doc.api.impl.node.style.ParagraphStyle;
import io.keikai.doc.ui.Docpad;
import io.keikai.doc.ui.tool.ToolInserter;
import java.util.Arrays;
import org.zkoss.zk.ui.Component;
import org.zkoss.zul.Combobox;
import org.zkoss.zul.Comboitem;
import org.zkoss.zul.Toolbar;

public class ParagraphTypeInserter
implements ToolInserter {
    @Override
    public void insertTool(Docpad docpad, Toolbar toolbar) {
        Editor editor = Editor.getInstance(docpad);
        Combobox cb = new Combobox();
        cb.setReadonly(true);
        cb.setTooltiptext("Paragraph Type");
        Arrays.stream(ParagraphStyle.Type.values()).forEach(t -> {
            Comboitem item = new Comboitem(t.toString());
            cb.appendChild((Component)item);
        });
        cb.addEventListener("onSelect", e -> {
            Comboitem selected = cb.getSelectedItem();
            if (selected == null) {
                return;
            }
            ParagraphStyle.Type t = ParagraphStyle.Type.valueOf(selected.getLabel().toUpperCase());
            editor.execute(Commands.findSelection().paragraphStyle(style -> style.withType(t)));
        });
        cb.setSelectedIndex(0);
        docpad.addEventListener("onDocpadChange", e -> {
            if (!toolbar.getParent().isVisible()) {
                return;
            }
            SelectionView sv = editor.getSelection();
            if (sv == null) {
                return;
            }
            boolean allMatched = sv.allParagraphStyleMatched(ParagraphStyle::getType);
            if (allMatched) {
                String t = sv.getStartParagraphStyle(ParagraphStyle::getType).toString().toLowerCase();
                cb.setSelectedItem((Comboitem)cb.getItems().stream().filter(i -> i.getLabel().equalsIgnoreCase(t)).findFirst().orElse(null));
            } else {
                cb.setValue("");
            }
        });
        toolbar.appendChild((Component)cb);
    }
}

